<!-- RAPID
     National e-Science centre
     Edinburgh

     Author Jos Koetsier

     This stylesheet adds unique symbols to a Rapid XML document.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:rapid="http://www.nesc.ac.uk/rapid" version="1.0"
                xmlns="http://www.nesc.ac.uk/rapid"  exclude-result-prefixes="#default">
	<xsl:output indent="yes" method="xml"/>

        <xsl:template match="rapid:*">
		<xsl:element name="{local-name(.)}" namespace="http://www.nesc.ac.uk/rapid">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="xhtml:*">
		<xsl:element name="{local-name(.)}" namespace="http://www.w3.org/1999/xhtml">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="@*">
		<xsl:attribute name="{local-name(.)}">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>
	<xsl:template match="rapid:page//rapid:variable|rapid:page//rapid:selection|rapid:page//rapid:fileupload|rapid:page//rapid:button">
		<xsl:element name="{local-name(.)}" namespace="http://www.nesc.ac.uk/rapid">
			<xsl:attribute name="symbol"><xsl:copy-of select="generate-id()"/></xsl:attribute>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
