/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.xml;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import uk.ac.nesc.rapid.symbol.SymbolTable;
import uk.ac.nesc.rapid.symbol.impl.SymbolTableImpl;
import uk.ac.nesc.rapid.xml.NoopRule;

public class SymbolTableReader {
    public static SymbolTable read(URL xmlFile) throws IOException, SAXException {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setNamespaceAware(true);
        SymbolTableImpl symbolTable = new SymbolTableImpl();
        digester.push((Object)symbolTable);
        digester.addFactoryCreate("*/page", (ObjectCreationFactory)new AttributeFactory("name"));
        digester.addCallMethod("*/radio", "setReadOnly", 1, new String[]{"java.lang.Boolean"});
        digester.addObjectParam("*/radio", 0, (Object)false);
        digester.addCallMethod("*/checkbox", "setReadOnly", 1, new String[]{"java.lang.Boolean"});
        digester.addObjectParam("*/checkbox", 0, (Object)false);
        digester.addCallMethod("*/text", "setReadOnly", 1, new String[]{"java.lang.Boolean"});
        digester.addObjectParam("*/text", 0, (Object)false);
        digester.addCallMethod("*/browser", "setReadOnly", 1, new String[]{"java.lang.Boolean"});
        digester.addObjectParam("*/browser", 0, (Object)false);
        digester.addCallMethod("*/list", "setReadOnly", 1, new String[]{"java.lang.Boolean"});
        digester.addObjectParam("*/list", 0, (Object)false);
        String variable = "variable";
        digester.addRule("rapid/initialise/variable", (Rule)new NoopRule());
        digester.addObjectCreate("*/variable", "uk.ac.nesc.rapid.symbol.impl.SymbolImpl");
        digester.addSetProperties("*/variable", new String[]{"symbol", "name"}, new String[]{"symbolName", "variableName"});
        digester.addSetRoot("*/variable", "addSymbol");
        digester.addSetTop("*/variable", "setPage", "java.lang.String");
        digester.addObjectCreate("*/fileupload", "uk.ac.nesc.rapid.symbol.impl.FileUploadSymbol");
        digester.addSetProperties("*/fileupload", new String[]{"symbol", "variable", "filesystem", "path"}, new String[]{"symbolName", "variableName", "fileSystemName", "path"});
        digester.addSetRoot("*/fileupload", "addSymbol");
        digester.addSetTop("*/fileupload", "setPage", "java.lang.String");
        digester.addObjectCreate("*/selection", "uk.ac.nesc.rapid.symbol.impl.GlobalVariableSymbol");
        digester.addSetProperties("*/selection", new String[]{"symbol", "name"}, new String[]{"symbolName", "variableName"});
        digester.addSetRoot("*/selection", "addSymbol");
        digester.addSetTop("*/selection", "setPage", "java.lang.String");
        digester.addSetProperties("*/radio", new String[]{"index"}, new String[]{"subJob"});
        digester.addSetProperties("*/text", new String[]{"index"}, new String[]{"subJob"});
        digester.parse(xmlFile);
        return symbolTable;
    }

    public static class AttributeFactory
    implements ObjectCreationFactory {
        private String attributeName = null;

        public AttributeFactory(String attributeName) {
            this.attributeName = attributeName;
        }

        public Object createObject(Attributes attributes) {
            String attr = attributes.getValue(this.attributeName);
            if (attr != null) {
                return attr;
            }
            return "";
        }

        public Digester getDigester() {
            return null;
        }

        public void setDigester(Digester digester) {
        }
    }
}

