/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.xml;

import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.plugin.PluginFactory;
import uk.ac.nesc.rapid.plugin.PluginTable;
import uk.ac.nesc.rapid.plugin.PluginTableImpl;
import uk.ac.nesc.rapid.plugin.RapidPlugin;

public class PluginReader
extends DefaultHandler {
    private SAXParser parser = null;
    private PluginTable pluginTable = new PluginTableImpl();
    private String page = "";
    private PluginFactory factory = null;

    public static PluginTable read(URL rapidSymbolURL, URL pluginURL) throws SAXException, IOException, ParserConfigurationException {
        PluginReader reader = new PluginReader(rapidSymbolURL, pluginURL);
        return reader.getPluginTable();
    }

    private PluginReader(URL rapidSymbolURL, URL pluginURL) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
        this.factory = new PluginFactory(pluginURL);
        factory.setNamespaceAware(true);
        this.parser = factory.newSAXParser();
        this.parser.parse(rapidSymbolURL.getPath(), (DefaultHandler)this);
    }

    public PluginTable getPluginTable() {
        return this.pluginTable;
    }

    public final void startElement(String uri, String localName, String qName, Attributes attributes) {
        try {
            if (uri.equals("http://www.nesc.ac.uk/rapid")) {
                if (localName.equals("page")) {
                    this.page = attributes.getValue("name");
                }
                if (localName.equals("plugin")) {
                    String className = attributes.getValue("class");
                    String fileName = attributes.getValue("file");
                    RapidPlugin plugin = this.factory.getPlugin(this.page, fileName, className);
                    this.pluginTable.addPlugin(plugin);
                }
            }
        }
        catch (RapidException ex) {
            // empty catch block
        }
    }
}

