/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.xml;

import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.persistence.JobPersistence;

public class PersistenceReader
extends DefaultHandler {
    private SAXParser parser = null;
    private boolean inPersistence = false;

    public PersistenceReader(URL url) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
        factory.setNamespaceAware(true);
        this.parser = factory.newSAXParser();
        this.parser.parse(url.getPath(), (DefaultHandler)this);
    }

    public static void read(URL url) throws SAXException, IOException, ParserConfigurationException {
        new PersistenceReader(url);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        try {
            if (uri.equals("http://www.nesc.ac.uk/rapid")) {
                if (this.inPersistence) {
                    if (localName.equals("username")) {
                        JobPersistence.setUsername(attributes.getValue("name"));
                    }
                    if (localName.equals("password")) {
                        JobPersistence.setPassword(attributes.getValue("name"));
                    }
                    if (localName.equals("dbms")) {
                        JobPersistence.setDbms(attributes.getValue("name"));
                    }
                    if (localName.equals("database")) {
                        JobPersistence.setDatabase(attributes.getValue("name"));
                    }
                    if (localName.equals("host")) {
                        JobPersistence.setHost(attributes.getValue("name"));
                    }
                } else if (localName.equals("persistence")) {
                    this.inPersistence = true;
                }
            }
        }
        catch (RapidException ex) {
            // empty catch block
        }
    }

    public void endElement(String uri, String localName, String qname) {
        if (uri.equals("http://www.nesc.ac.uk/rapid") && localName.equals("persistence")) {
            this.inPersistence = false;
        }
    }
}

