/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.xml;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.job.DataStage;
import uk.ac.nesc.rapid.job.Job;
import uk.ac.nesc.rapid.job.StageType;
import uk.ac.nesc.rapid.job.impl.DataStageImpl;
import uk.ac.nesc.rapid.job.impl.DataStageURLImpl;
import uk.ac.nesc.rapid.job.impl.JobImpl;
import uk.ac.nesc.rapid.xml.StackToParamRule;

public class JobReader {
    public static Job read(URL xmlFile) throws IOException, SAXException {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setNamespaceAware(true);
        JobImpl job = new JobImpl();
        digester.push((Object)job);
        String initialise = "*/initialise/";
        String path = "datastage/path";
        String dot = "datastage/deleteontermination";
        String cflag = "datastage/creationflag";
        String dotarget = "datastage/dotarget";
        String filesystem = "datastage/filesystem";
        String filename = "datastage/filename";
        String stdin = "posix/stdin";
        String stdout = "posix/stdout";
        String stderr = "posix/stderr";
        String workingdir = "posix/workingdir";
        String parameter = "posix/parameter";
        String executable = "posix/executable";
        String envname = "posix/environmentname";
        String envvalue = "posix/environmentvalue";
        String variable = "variable";
        String submitto = "submitto";
        digester.addFactoryCreate("*/initialise/datastage/path", (ObjectCreationFactory)new DataStageURLFactory(job));
        digester.addCallMethod("*/initialise/datastage/path", "setPath", 1, new String[]{"uk.ac.nesc.rapid.value.Value"});
        digester.addFactoryCreate("*/initialise/datastage/deleteontermination", (ObjectCreationFactory)new DataStageFactory(job));
        digester.addCallMethod("*/initialise/datastage/deleteontermination", "setDeleteOnTermination", 1, new String[]{"uk.ac.nesc.rapid.value.Value"});
        digester.addFactoryCreate("*/initialise/datastage/creationflag", (ObjectCreationFactory)new DataStageFactory(job));
        digester.addCallMethod("*/initialise/datastage/creationflag", "setCreationFlag", 1, new String[]{"uk.ac.nesc.rapid.value.Value"});
        digester.addFactoryCreate("*/initialise/datastage/dotarget", (ObjectCreationFactory)new DataStageFactory(job));
        digester.addCallMethod("*/initialise/datastage/dotarget", "setDoTarget", 1, new String[]{"uk.ac.nesc.rapid.value.Value"});
        digester.addCallMethod("*/initialise/submitto", "setSubmissionServer", 1, new String[]{"uk.ac.nesc.rapid.value.Value"});
        digester.addCallMethod("*/initialise/posix/stdin", "setStdin", 1, new String[]{"uk.ac.nesc.rapid.value.Value"});
        digester.addCallMethod("*/initialise/posix/stdout", "setStdout", 1, new String[]{"uk.ac.nesc.rapid.value.Value"});
        digester.addCallMethod("*/initialise/posix/stderr", "setStderr", 1, new String[]{"uk.ac.nesc.rapid.value.Value"});
        digester.addCallMethod("*/initialise/posix/workingdir", "setWorkingDir", 1, new String[]{"uk.ac.nesc.rapid.value.Value"});
        digester.addCallMethod("*/initialise/posix/parameter", "addParameter", 2, new String[]{"java.lang.Integer", "uk.ac.nesc.rapid.value.Value"});
        digester.addCallParam("*/initialise/posix/parameter", 0, "index");
        digester.addFactoryCreate("*/initialise/datastage/filesystem", (ObjectCreationFactory)new DataStageURLFactory(job));
        digester.addCallMethod("*/initialise/datastage/filesystem", "setFileSystem", 1, new String[]{"uk.ac.nesc.rapid.value.Value"});
        digester.addFactoryCreate("*/initialise/datastage/filename", (ObjectCreationFactory)new DataStageFactory(job));
        digester.addCallMethod("*/initialise/datastage/filename", "setFileName", 1, new String[]{"uk.ac.nesc.rapid.value.Value"});
        digester.addCallMethod("*/initialise/posix/executable", "setExecutable", 1, new String[]{"uk.ac.nesc.rapid.value.Value"});
        digester.addCallMethod("*/initialise/posix/environmentvalue", "addEnvironmentValue", 2, new String[]{"java.lang.Integer", "uk.ac.nesc.rapid.value.Value"});
        digester.addCallParam("*/initialise/posix/environmentvalue", 0, "index");
        digester.addCallMethod("*/initialise/posix/environmentname", "addEnvironmentName", 2, new String[]{"java.lang.Integer", "uk.ac.nesc.rapid.value.Value"});
        digester.addCallParam("*/initialise/posix/environmentname", 0, "index");
        digester.addCallMethod("*/initialise/variable", "setVariable", 2, new String[]{"java.lang.String", "uk.ac.nesc.rapid.value.Value"});
        digester.addCallParam("*/initialise/variable", 0, "name");
        digester.addObjectCreate("*/array", "uk.ac.nesc.rapid.value.impl.ArrayValue");
        digester.addObjectCreate("*/single", "uk.ac.nesc.rapid.value.impl.SingleValue");
        digester.addObjectCreate("*/range", "uk.ac.nesc.rapid.value.impl.RangeValue");
        digester.addObjectCreate("*/uuid", "uk.ac.nesc.rapid.value.impl.UUIDValue");
        digester.addRule("*/array", (Rule)new StackToParamRule());
        digester.addRule("*/single", (Rule)new StackToParamRule());
        digester.addSetProperties("*/single", new String[]{"infile", "outfile"}, new String[]{"inFile", "outFile"});
        digester.addRule("*/range", (Rule)new StackToParamRule());
        digester.addRule("*/uuid", (Rule)new StackToParamRule());
        digester.addCallMethod("*/value", "put", 1);
        digester.addCallParam("*/value", 0);
        digester.addCallMethod("*/min", "setMin", 1, new String[]{"java.lang.Double"});
        digester.addCallParam("*/min", 0);
        digester.addCallMethod("*/max", "setMax", 1, new String[]{"java.lang.Double"});
        digester.addCallParam("*/max", 0);
        digester.addCallMethod("*/step", "setStep", 1, new String[]{"java.lang.Double"});
        digester.addCallParam("*/step", 0);
        digester.addCallMethod("*/regexp", "setRegExp", 1);
        digester.addCallParam("*/regexp", 0);
        digester.addCallMethod("*/errormessage", "setErrorMessage", 1);
        digester.addCallParam("*/errormessage", 0);
        digester.parse(xmlFile);
        return job;
    }

    public static class DataStageURLFactory
    implements ObjectCreationFactory {
        Job job;

        public DataStageURLFactory(Job job) {
            this.job = job;
        }

        public Object createObject(Attributes attributes) {
            try {
                StageType stageType;
                DataStage dataStage;
                String dataStageName = attributes.getValue("datastage");
                String type = attributes.getValue("type");
                if (!this.job.existsDataStage(dataStageName)) {
                    this.job.addDataStage(dataStageName, new DataStageImpl());
                }
                if (!(dataStage = this.job.getDataStage(dataStageName)).existsURL(stageType = StageType.parseString(type))) {
                    dataStage.setURL(new DataStageURLImpl(), StageType.parseString(type));
                }
                return dataStage.getURL(StageType.parseString(type));
            }
            catch (RapidException ex) {
                return null;
            }
        }

        public Digester getDigester() {
            return null;
        }

        public void setDigester(Digester digester) {
        }
    }

    public static class DataStageFactory
    implements ObjectCreationFactory {
        Job job;

        public DataStageFactory(Job job) {
            this.job = job;
        }

        public Object createObject(Attributes attributes) {
            String dataStageName = attributes.getValue("datastage");
            if (!this.job.existsDataStage(dataStageName)) {
                this.job.addDataStage(dataStageName, new DataStageImpl());
            }
            DataStage dataStage = null;
            try {
                dataStage = this.job.getDataStage(dataStageName);
            }
            catch (RapidException ex) {
                // empty catch block
            }
            return dataStage;
        }

        public Digester getDigester() {
            return null;
        }

        public void setDigester(Digester digester) {
        }
    }
}

