/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.value.impl;

import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jsp.ValuePrinter;
import uk.ac.nesc.rapid.value.Value;
import uk.ac.nesc.rapid.value.impl.BaseValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@DiscriminatorValue(value="RANGEVALUE")
@Table(name="RANGEVALUE")
public class RangeValue
extends BaseValue
implements PersistenceCapable {
    @Column(name="MINVALUE")
    @Basic
    private double min = 0.0;
    @Column(name="MAXVALUE")
    @Basic
    private double max = 1.0;
    @Basic
    private double step = 1.0;
    private static int pcInheritedFieldCount = BaseValue.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Luk$ac$nesc$rapid$value$impl$BaseValue;
    static /* synthetic */ Class class$Luk$ac$nesc$rapid$value$impl$RangeValue;

    public RangeValue() {
    }

    public RangeValue(double min, double max, double step) {
        this.min = min;
        this.max = max;
        this.step = step;
    }

    @Override
    public void put(int index, String value) {
        try {
            if (index == 0) {
                RangeValue.pcSetmin(this, Double.parseDouble(value));
            } else if (index == 1) {
                RangeValue.pcSetmax(this, Double.parseDouble(value));
            } else if (index == 2) {
                RangeValue.pcSetstep(this, Double.parseDouble(value));
            }
        }
        catch (NumberFormatException ex) {
            RangeValue.pcSetmin(this, 0.0);
            RangeValue.pcSetmax(this, 0.0);
            RangeValue.pcSetstep(this, 1.0);
        }
    }

    public double getMax() {
        return RangeValue.pcGetmax(this);
    }

    public void setMax(double max) {
        RangeValue.pcSetmax(this, max);
    }

    public double getMin() {
        return RangeValue.pcGetmin(this);
    }

    public void setMin(double min) {
        RangeValue.pcSetmin(this, min);
    }

    public double getStep() {
        return RangeValue.pcGetstep(this);
    }

    public void setStep(double step) {
        if (step > 0.0) {
            RangeValue.pcSetstep(this, step);
        } else {
            RangeValue.pcSetstep(this, 1.0);
        }
    }

    @Override
    public String get() {
        return Double.toString(RangeValue.pcGetmin(this));
    }

    @Override
    public String get(int index) {
        double result = RangeValue.pcGetmin(this) + RangeValue.pcGetstep(this) * (double)index;
        return result <= RangeValue.pcGetmax(this) ? Double.toString(result) : Double.toString(RangeValue.pcGetmin(this) + RangeValue.pcGetstep(this) * (double)(this.size() - 1));
    }

    public boolean exists(String value) {
        try {
            int intValue = Integer.parseInt(value);
            return (double)intValue >= RangeValue.pcGetmin(this) && (double)intValue <= RangeValue.pcGetmax(this);
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    @Override
    public void put(String value) {
        try {
            RangeValue.pcSetmin(this, Double.parseDouble(value));
            RangeValue.pcSetmax(this, RangeValue.pcGetmin(this));
        }
        catch (NumberFormatException ex) {
            RangeValue.pcSetmin(this, 0.0);
            RangeValue.pcSetmax(this, 0.0);
        }
    }

    @Override
    public void put(String[] values) {
        try {
            if (values.length > 0) {
                RangeValue.pcSetmin(this, Double.parseDouble(values[0]));
            }
            if (values.length > 1) {
                RangeValue.pcSetmax(this, Double.parseDouble(values[1]));
            }
            if (values.length > 2) {
                RangeValue.pcSetstep(this, Double.parseDouble(values[2]));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public int size() {
        return (int)((RangeValue.pcGetmax(this) - RangeValue.pcGetmin(this)) / RangeValue.pcGetstep(this)) + 1;
    }

    @Override
    public void put(List<String> values) {
        try {
            if (values.size() > 0) {
                RangeValue.pcSetmin(this, Double.parseDouble(values.get(0)));
            }
            if (values.size() > 1) {
                RangeValue.pcSetmax(this, Double.parseDouble(values.get(1)));
            }
            if (values.size() > 2) {
                RangeValue.pcSetstep(this, Double.parseDouble(values.get(2)));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public String print(ValuePrinter printer) throws RapidException {
        return printer.print(this);
    }

    @Override
    public Value copy() {
        return new RangeValue(RangeValue.pcGetmin(this), RangeValue.pcGetmax(this), RangeValue.pcGetstep(this));
    }

    public String toString() {
        String result = "";
        result = result + "RangeValue\n";
        result = result + "min " + RangeValue.pcGetmin(this) + "\n";
        result = result + "max " + RangeValue.pcGetmax(this) + "\n";
        result = result + "stepsize " + RangeValue.pcGetmax(this) + "\n";
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangeValue other = (RangeValue)obj;
        if (RangeValue.pcGetmin(this) != RangeValue.pcGetmin(other)) {
            return false;
        }
        if (RangeValue.pcGetmax(this) != RangeValue.pcGetmax(other)) {
            return false;
        }
        return RangeValue.pcGetstep(this) == RangeValue.pcGetstep(other);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + (int)(Double.doubleToLongBits(RangeValue.pcGetmin(this)) ^ Double.doubleToLongBits(RangeValue.pcGetmin(this)) >>> 32);
        hash = 71 * hash + (int)(Double.doubleToLongBits(RangeValue.pcGetmax(this)) ^ Double.doubleToLongBits(RangeValue.pcGetmax(this)) >>> 32);
        hash = 71 * hash + (int)(Double.doubleToLongBits(RangeValue.pcGetstep(this)) ^ Double.doubleToLongBits(RangeValue.pcGetstep(this)) >>> 32);
        return hash;
    }

    @Override
    public String resolve(JobData data, int subJob) throws RapidException {
        return this.get(subJob);
    }

    @Override
    public int resolveSize(JobData data) throws RapidException {
        return this.size();
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        Class clazz = class$Luk$ac$nesc$rapid$value$impl$BaseValue != null ? class$Luk$ac$nesc$rapid$value$impl$BaseValue : (class$Luk$ac$nesc$rapid$value$impl$BaseValue = RangeValue.class$("uk.ac.nesc.rapid.value.impl.BaseValue"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"max", "min", "step"};
        Class[] classArray = new Class[3];
        classArray[0] = Double.TYPE;
        classArray[1] = Double.TYPE;
        classArray[2] = Double.TYPE;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26};
        Class clazz2 = class$Luk$ac$nesc$rapid$value$impl$RangeValue != null ? class$Luk$ac$nesc$rapid$value$impl$RangeValue : (class$Luk$ac$nesc$rapid$value$impl$RangeValue = RangeValue.class$("uk.ac.nesc.rapid.value.impl.RangeValue"));
        PCRegistry.register((Class)clazz2, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"RangeValue", (PersistenceCapable)new RangeValue());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.max = 0.0;
        this.min = 0.0;
        this.step = 0.0;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        RangeValue rangeValue = new RangeValue();
        if (bl) {
            rangeValue.pcClearFields();
        }
        rangeValue.pcStateManager = stateManager;
        rangeValue.pcCopyKeyFieldsFromObjectId(object);
        return rangeValue;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        RangeValue rangeValue = new RangeValue();
        if (bl) {
            rangeValue.pcClearFields();
        }
        rangeValue.pcStateManager = stateManager;
        return rangeValue;
    }

    protected static int pcGetManagedFieldCount() {
        return 3 + BaseValue.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.max = this.pcStateManager.replaceDoubleField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.min = this.pcStateManager.replaceDoubleField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.step = this.pcStateManager.replaceDoubleField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedDoubleField((PersistenceCapable)this, n, this.max);
                return;
            }
            case 1: {
                this.pcStateManager.providedDoubleField((PersistenceCapable)this, n, this.min);
                return;
            }
            case 2: {
                this.pcStateManager.providedDoubleField((PersistenceCapable)this, n, this.step);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(RangeValue rangeValue, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(rangeValue, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.max = rangeValue.max;
                return;
            }
            case 1: {
                this.min = rangeValue.min;
                return;
            }
            case 2: {
                this.step = rangeValue.step;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        RangeValue rangeValue = (RangeValue)object;
        if (rangeValue.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(rangeValue, nArray[n]);
            ++n;
        }
    }

    private static final double pcGetmax(RangeValue rangeValue) {
        if (rangeValue.pcStateManager == null) {
            return rangeValue.max;
        }
        int n = pcInheritedFieldCount + 0;
        rangeValue.pcStateManager.accessingField(n);
        return rangeValue.max;
    }

    private static final void pcSetmax(RangeValue rangeValue, double d) {
        if (rangeValue.pcStateManager == null) {
            rangeValue.max = d;
            return;
        }
        rangeValue.pcStateManager.settingDoubleField((PersistenceCapable)rangeValue, pcInheritedFieldCount + 0, rangeValue.max, d, 0);
    }

    private static final double pcGetmin(RangeValue rangeValue) {
        if (rangeValue.pcStateManager == null) {
            return rangeValue.min;
        }
        int n = pcInheritedFieldCount + 1;
        rangeValue.pcStateManager.accessingField(n);
        return rangeValue.min;
    }

    private static final void pcSetmin(RangeValue rangeValue, double d) {
        if (rangeValue.pcStateManager == null) {
            rangeValue.min = d;
            return;
        }
        rangeValue.pcStateManager.settingDoubleField((PersistenceCapable)rangeValue, pcInheritedFieldCount + 1, rangeValue.min, d, 0);
    }

    private static final double pcGetstep(RangeValue rangeValue) {
        if (rangeValue.pcStateManager == null) {
            return rangeValue.step;
        }
        int n = pcInheritedFieldCount + 2;
        rangeValue.pcStateManager.accessingField(n);
        return rangeValue.step;
    }

    private static final void pcSetstep(RangeValue rangeValue, double d) {
        if (rangeValue.pcStateManager == null) {
            rangeValue.step = d;
            return;
        }
        rangeValue.pcStateManager.settingDoubleField((PersistenceCapable)rangeValue, pcInheritedFieldCount + 2, rangeValue.step, d, 0);
    }
}

