/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.symbol.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.symbol.Symbol;
import uk.ac.nesc.rapid.symbol.SymbolTable;
import uk.ac.nesc.rapid.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolTableImpl
implements SymbolTable {
    private Map<String, Symbol> symbolMap = new HashMap<String, Symbol>();
    private Map<String, Collection<Symbol>> symbolPageMap = new HashMap<String, Collection<Symbol>>();
    private Map<String, Symbol> temporarySymbolMap = new HashMap<String, Symbol>();
    private Map<String, Value> globalSymbols = new HashMap<String, Value>();

    @Override
    public Symbol getSymbol(String name) throws RapidException {
        Symbol result = this.symbolMap.get(name);
        if (result == null) {
            throw new RapidException("Could not find symbol " + name + " in the symbol table");
        }
        return result;
    }

    @Override
    public boolean existsTemporarySymbol(String name) {
        return this.temporarySymbolMap.containsKey(name);
    }

    @Override
    public void addTemporarySymbol(Symbol symbol) {
        this.temporarySymbolMap.put(symbol.getSymbolName(), symbol);
    }

    @Override
    public void clearTemporarySymbols() {
        this.temporarySymbolMap = new HashMap<String, Symbol>();
    }

    @Override
    public Collection<Symbol> getTemporarySymbolCollection() {
        return this.temporarySymbolMap.values();
    }

    @Override
    public void addSymbol(Symbol symbol) {
        this.symbolMap.put(symbol.getSymbolName(), symbol);
        String page = symbol.getPage();
        Collection<Symbol> symbolPageCollection = this.symbolPageMap.get(page);
        if (symbolPageCollection == null) {
            symbolPageCollection = new Vector<Symbol>();
            this.symbolPageMap.put(page, symbolPageCollection);
        }
        symbolPageCollection.add(symbol);
    }

    @Override
    public int size() {
        return this.symbolMap.size();
    }

    @Override
    public Collection<Symbol> getSymbolsByPage(String page) {
        Collection<Symbol> result = this.symbolPageMap.get(page);
        if (result == null) {
            return new Vector<Symbol>();
        }
        return result;
    }

    @Override
    public boolean exists(String name, String page) {
        Symbol symbol = this.symbolMap.get(name);
        return symbol != null && page.equals(symbol.getPage());
    }

    @Override
    public boolean exists(String name) {
        return this.symbolMap.containsKey(name);
    }
}

