/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.plugin;

import java.util.List;
import java.util.Set;
import uk.ac.nesc.rapid.data.RapidData;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.JobManager;
import uk.ac.nesc.rapid.plugin.element.CheckBoxInput;
import uk.ac.nesc.rapid.plugin.element.HTMLOutput;
import uk.ac.nesc.rapid.plugin.element.JobSelection;
import uk.ac.nesc.rapid.plugin.element.ListInput;
import uk.ac.nesc.rapid.plugin.element.RadioInput;
import uk.ac.nesc.rapid.plugin.element.TextInput;
import uk.ac.nesc.rapid.util.JobTableUtil;
import uk.ac.nesc.rapid.value.impl.JobIDValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RapidPlugin {
    StringBuffer output = new StringBuffer();
    private String page = "";
    private RapidData data = null;

    public abstract void doAction();

    public final void initialise(RapidData data) {
        this.data = data;
        this.output.setLength(0);
    }

    public final void addHTML(String HTML) throws RapidException {
        this.output.append(HTMLOutput.getOutput(this.data, HTML));
    }

    public final void addTextInput(String variable, int rows, int cols) throws RapidException {
        this.output.append(TextInput.getOutput(this.data, variable, rows, cols, -1, false));
    }

    public final void addTextInput(String variable, int rows, int cols, int index) throws RapidException {
        this.output.append(TextInput.getOutput(this.data, variable, rows, cols, index, false));
    }

    public final void addListInput(String variable, int size, boolean refresh, List<String> optionList, List<String> displayList) throws RapidException {
        this.output.append(ListInput.getOutput(this.data, variable, size, refresh, -1, optionList, displayList));
    }

    public final void addRadioInput(String variable, String groupName, boolean refresh, String option) throws RapidException {
        this.output.append(RadioInput.getOutput(this.data, variable, groupName, refresh, -1, option));
    }

    public final void addRadioInput(String variable, String groupName, boolean refresh, String option, int index) throws RapidException {
        this.output.append(RadioInput.getOutput(this.data, variable, groupName, refresh, index, option));
    }

    public final void addCheckBoxInput(String variable, String groupName, String option) throws RapidException {
        this.output.append(CheckBoxInput.getOutput(this.data, variable, groupName, option));
    }

    public final void addJobSelection(String jobID, String selectionID) throws RapidException {
        this.output.append(JobSelection.get(this.data, jobID, selectionID));
    }

    public final String getVariable(String variable) throws RapidException {
        return this.data.getJobData().getVariable(variable).get();
    }

    public final String getVariable(String variable, int index) throws RapidException {
        return this.data.getJobData().getVariable(variable).get(index);
    }

    public final int getVariableSize(String variable) throws RapidException {
        return this.data.getJobData().getVariable(variable).size();
    }

    public final String getVariable(String variable, String jobID) throws RapidException {
        return this.data.getJobDataTable().getJobData(jobID).getVariable(variable).get();
    }

    public final String getVariable(String variable, int index, String jobID) throws RapidException {
        return this.data.getJobDataTable().getJobData(jobID).getVariable(variable).get(index);
    }

    public final int getVariableSize(String variable, String jobID) throws RapidException {
        return this.data.getJobDataTable().getJobData(jobID).getVariable(variable).size();
    }

    public final void setVariable(String variable, String value) throws RapidException {
        this.data.getJobData().getVariable(variable).put(value);
    }

    public final void setVariable(String variable, List<String> valueList) throws RapidException {
        this.data.getJobData().getVariable(variable).put(valueList);
    }

    public final String getJobSelection(String selection) throws RapidException {
        return this.data.getGlobalVariableTable().getGlobalVariable(selection).get();
    }

    public final String getJobStatus(String jobID) throws RapidException {
        JobData jobData = this.data.getJobDataTable().getJobData(jobID);
        JobManager manager = this.data.getJobQueueTable().getJobManager(jobData);
        int index = JobIDValue.getSubJobIndex(jobID);
        return manager.monitor().get(index);
    }

    public final Set<String> getJobIDSet() {
        return this.data.getJobDataTable().getJobIDSet();
    }

    public final List<String> getJobIDList() {
        return JobTableUtil.getOrderedJobIDs(this.data.getJobDataTable());
    }

    public final String getJobDate(String jobID) throws RapidException {
        return this.data.getJobDataTable().getJobData(jobID).getDate().toString();
    }

    public final String getUsername() {
        return this.data.getUserName() == null ? "" : this.data.getUserName();
    }

    public final StringBuffer getOutput() {
        return this.output;
    }

    public final void setPage(String page) {
        this.page = page;
    }

    public final String getPage() {
        return this.page;
    }
}

