/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.plugin;

import java.net.URL;
import java.util.Properties;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.plugin.RapidPlugin;

public class PluginFactory {
    private static PythonInterpreter interpreter = null;

    public PluginFactory(URL pythonPath) {
        if (interpreter == null) {
            Properties props = new Properties();
            props.setProperty("python.path", pythonPath.getPath());
            PythonInterpreter.initialize((Properties)System.getProperties(), (Properties)props, (String[])new String[]{""});
            interpreter = new PythonInterpreter();
        }
    }

    public RapidPlugin getPlugin(String page, String fileName, String pluginClass) throws RapidException {
        interpreter.exec("from " + fileName + " import " + pluginClass);
        PyObject rapidClass = interpreter.get(pluginClass);
        if (rapidClass == null) {
            throw new RapidException("Could not find plugin! Name: " + fileName + " class " + pluginClass);
        }
        PyObject rapidObject = rapidClass.__call__();
        if (rapidObject == null) {
            throw new RapidException("Error loading plugin! Name: " + fileName + " class " + pluginClass);
        }
        RapidPlugin rapidPlugin = (RapidPlugin)rapidObject.__tojava__(RapidPlugin.class);
        rapidPlugin.setPage(page);
        return rapidPlugin;
    }
}

