/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.persistence;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobdata.JobDataImpl;
import uk.ac.nesc.rapid.jobdata.JobDataTable;
import uk.ac.nesc.rapid.jobdata.JobDataTableImpl;
import uk.ac.nesc.rapid.jobsubmission.JobQueueTable;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.JobManager;

public class JobPersistence {
    public static final String POSTGRES = "postgres";
    public static final String MYSQL = "mysql";
    public static final String H2 = "h2";
    public static final String HSQLDB = "hsqldb";
    public static final String FILE = "file";
    private static EntityManagerFactory factory = null;
    private static Map<String, String> properties = null;
    private static String username = null;
    private static String password = null;
    private static String database = null;
    private static String dbms = null;
    private static String host = null;

    public static synchronized String getDatabase() {
        return database;
    }

    public static synchronized void setDatabase(String database) {
        if (factory == null) {
            JobPersistence.database = database;
        }
    }

    public static synchronized String getDbms() {
        return dbms;
    }

    public static synchronized void setDbms(String dbms) throws RapidException {
        if (factory != null) {
            throw new RapidException("Database is open while attempting to set DBMS");
        }
        JobPersistence.dbms = dbms;
    }

    public static synchronized String getHost() {
        return host;
    }

    public static synchronized void setHost(String host) throws RapidException {
        if (factory != null) {
            throw new RapidException("Database is open while attempting to set Host");
        }
        JobPersistence.host = host;
    }

    public static synchronized String getPassword() {
        return password;
    }

    public static synchronized void setPassword(String password) throws RapidException {
        if (factory != null) {
            throw new RapidException("Database is open while attempting to set Password");
        }
        JobPersistence.password = password;
    }

    public static synchronized String getUsername() {
        return username;
    }

    public static synchronized void setUsername(String username) throws RapidException {
        if (factory != null) {
            throw new RapidException("Database is open while attempting to set username");
        }
        JobPersistence.username = username;
    }

    public static synchronized void stopDatabase() {
        JobPersistence.flush();
        factory.close();
        factory = null;
    }

    public static synchronized void startDatabase() throws RapidException {
        try {
            if (factory != null) {
                return;
            }
            properties = new HashMap<String, String>();
            properties.put("openjpa.ConnectionUserName", username);
            properties.put("openjpa.ConnectionPassword", password);
            String driver = null;
            String scheme = null;
            if (POSTGRES.equalsIgnoreCase(dbms)) {
                driver = "org.postgresql.Driver";
                scheme = "postgresql";
            } else if (MYSQL.equalsIgnoreCase(dbms)) {
                driver = "com.mysql.jdbc.Driver";
                scheme = MYSQL;
            } else if (H2.equalsIgnoreCase(dbms)) {
                driver = "org.h2.Driver";
                scheme = H2;
            } else if (HSQLDB.equalsIgnoreCase(dbms)) {
                driver = "org.hsqldb.jdbcDriver";
                scheme = HSQLDB;
            }
            if (FILE.equalsIgnoreCase(dbms)) {
                driver = "org.hsqldb.jdbcDriver";
                properties.put("openjpa.ConnectionURL", "jdbc:hsqldb:file:" + database + ";shutdown=true");
            } else {
                properties.put("openjpa.ConnectionURL", "jdbc:" + scheme + "://" + host + "/" + database);
            }
            properties.put("openjpa.ConnectionDriverName", driver);
            factory = Persistence.createEntityManagerFactory((String)"rapid", properties);
        }
        catch (PersistenceException ex) {
            throw new RapidException("Error initialising Database " + JobPersistence.getError(ex));
        }
    }

    public static void reload() throws RapidException {
        JobPersistence.stopDatabase();
        JobPersistence.startDatabase();
    }

    public static synchronized void dropDatabase() {
        String[] entities;
        EntityManager em = factory.createEntityManager();
        for (String entity : entities = new String[]{"JobDataImpl"}) {
            em.getTransaction().begin();
            Query query = em.createQuery("delete from " + entity);
            query.executeUpdate();
            em.getTransaction().commit();
        }
        em.close();
    }

    private static void flush() {
        if (factory == null) {
            return;
        }
        EntityManager em = factory.createEntityManager();
        em.getTransaction().begin();
        if (FILE.equalsIgnoreCase(dbms)) {
            em.createNativeQuery("CHECKPOINT");
        }
        em.flush();
        em.getTransaction().commit();
        em.close();
    }

    private static String getError(PersistenceException ex) {
        String message = ex.getMessage() + " CAUSE: ";
        for (Throwable t = ex.getCause(); t != null; t = t.getCause()) {
            message = message + t.getMessage() + " : ";
        }
        return message;
    }

    public static synchronized void newJobData(JobData jobData) throws RapidException {
        try {
            if (factory == null) {
                return;
            }
            EntityManager em = factory.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)jobData);
            em.getTransaction().commit();
            em.close();
            JobPersistence.flush();
        }
        catch (PersistenceException ex) {
            throw new RapidException("Error creating new Job Data in database " + JobPersistence.getError(ex));
        }
    }

    public static synchronized void updateJobData(JobData jobData) throws RapidException {
        try {
            if (factory == null) {
                return;
            }
            EntityManager em = factory.createEntityManager();
            em.getTransaction().begin();
            em.merge((Object)jobData);
            em.getTransaction().commit();
            em.close();
        }
        catch (PersistenceException ex) {
            throw new RapidException("Error updating Job Data in Database: " + JobPersistence.getError(ex));
        }
    }

    public static synchronized int deleteJobData(JobData jobData) throws RapidException {
        try {
            if (factory == null) {
                return 0;
            }
            EntityManager em = factory.createEntityManager();
            em.getTransaction().begin();
            Query query = em.createQuery("delete from JobDataImpl j where j.serial like :id");
            query.setParameter("id", (Object)jobData.getSerial());
            int deleted = query.executeUpdate();
            em.getTransaction().commit();
            em.close();
            return deleted;
        }
        catch (PersistenceException ex) {
            throw new RapidException("Error deleting Job Data in Database: " + JobPersistence.getError(ex));
        }
    }

    public static synchronized JobDataTable loadJobDataTable(String userName) throws RapidException {
        try {
            if (factory == null) {
                return null;
            }
            EntityManager em = factory.createEntityManager();
            em.getTransaction().begin();
            Query query = em.createQuery("select j from JobDataImpl j where j.userName='" + userName + "'");
            List jobDataList = query.getResultList();
            em.getTransaction().commit();
            em.close();
            JobDataTableImpl jobDataTable = new JobDataTableImpl();
            for (JobDataImpl jobData : jobDataList) {
                jobDataTable.addJobData(jobData);
            }
            return jobDataTable;
        }
        catch (PersistenceException ex) {
            throw new RapidException("Error loading Job Data Table in Database: " + JobPersistence.getError(ex));
        }
    }

    public static synchronized void restartJobSubmissions(JobQueueTable jobQueueTable, JobDataTable jobDataTable) throws RapidException {
        for (String jobID : jobDataTable.getJobIDSet()) {
            JobData jobData = jobDataTable.getJobData(jobID);
            JobManager manager = jobQueueTable.addJobManager(jobData);
            manager.runJob();
        }
    }
}

