/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.main;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import uk.ac.nesc.rapid.data.RapidConfiguration;
import uk.ac.nesc.rapid.jsp.Generator;
import uk.ac.nesc.rapid.xml.RapidConfigurationReader;
import uk.ac.nesc.rapid.xml.RapidSchema;
import uk.ac.nesc.rapid.xml.RapidTransform;
import uk.ac.nesc.rapid.xml.RapidXML;

public class Install {
    public static void main(String[] args) throws Exception {
        boolean isPortlet = true;
        String directory = "webapp" + File.separator + "jsp" + File.separator;
        for (int i = 0; i < args.length; ++i) {
            if ("help".equalsIgnoreCase(args[i])) {
                System.out.println("Usage: java uk.ac.nesc.rapid.main.Install [destination directory] [-servlet]");
                continue;
            }
            if ("-servlet".equalsIgnoreCase(args[i])) {
                isPortlet = false;
                continue;
            }
            directory = args[0];
            if (directory.endsWith(File.separator)) continue;
            directory = directory + File.separator;
        }
        try {
            RapidSchema.validate(RapidXML.getXMLFile().getPath());
        }
        catch (SAXParseException ex) {
            System.out.println("Error validating schema file at line: " + ex.getLineNumber() + " col: " + ex.getColumnNumber());
            System.out.println(ex.getMessage());
            System.exit(1);
        }
        catch (IOException ex) {
            System.out.println("Error loading XML file: " + ex.getMessage());
            System.exit(1);
        }
        catch (VerifierConfigurationException ex) {
            ex.printStackTrace();
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        System.out.println("Rapid XML document validated.");
        try {
            RapidTransform.transform();
        }
        catch (FileNotFoundException ex) {
            System.out.println("Could not find XML file: " + ex.getMessage());
            System.exit(1);
        }
        catch (IOException ex) {
            System.out.println("Error loading XML file: " + ex.getMessage());
            System.exit(1);
        }
        catch (TransformerException ex) {
            System.out.println("Could not perform XML transformation: " + ex.getMessage());
        }
        System.out.println("Successfully transformed XML document.");
        URL url = RapidXML.getXMLSymbolFile();
        RapidConfiguration config = null;
        try {
            config = RapidConfigurationReader.read(url);
        }
        catch (SAXException ex) {
            System.out.println("Error reading in XML pages " + ex.getMessage());
            System.exit(1);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.out.println("Error loading XML file: " + ex.getMessage());
            System.exit(1);
        }
        System.out.println("Read pages.");
        Generator generator = new Generator(isPortlet);
        try {
            generator.generate(url);
        }
        catch (SAXException ex) {
            System.out.println("Error generating XML pages " + ex.getMessage());
            System.exit(1);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.out.println("Error loading XML file: " + ex.getMessage());
            System.exit(1);
        }
        System.out.println("Generated JSP");
        List<String> pages = generator.getPageList();
        for (int i = 0; i < pages.size(); ++i) {
            try {
                String page = pages.get(i);
                System.out.println("Writing: " + directory + config.getPage(i) + ".jsp");
                System.out.println(page);
                File f = new File(directory + config.getPage(i) + ".jsp");
                FileWriter fw = new FileWriter(f);
                fw.write(page);
                fw.close();
                continue;
            }
            catch (IOException ex) {
                System.out.println("Cannot write jsp file " + directory + config.getPage(i) + ".jsp : " + ex.getMessage());
                System.exit(1);
            }
        }
    }
}

