/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jsp;

import uk.ac.nesc.rapid.jsp.ValuePrinter;
import uk.ac.nesc.rapid.value.impl.ArrayValue;
import uk.ac.nesc.rapid.value.impl.RangeValue;
import uk.ac.nesc.rapid.value.impl.SingleValue;

public class JSPTextPrinter
implements ValuePrinter {
    private String symbol = null;
    private String rows = null;
    private String cols = null;
    private String isPassword = null;
    private int index = -1;

    public JSPTextPrinter(String symbol, String rows, String cols) {
        this.symbol = symbol;
        this.rows = rows;
    }

    public JSPTextPrinter(String symbol, String rows, String cols, String index, String isPassword) {
        this.symbol = symbol;
        this.rows = rows;
        this.cols = cols;
        this.isPassword = isPassword;
        if (index != null) {
            try {
                this.index = Integer.parseInt(index);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
    }

    public String print(SingleValue value) {
        return this.print(value.get());
    }

    public String print(ArrayValue value) {
        return this.print(this.index == -1 ? value.get() : value.get(this.index));
    }

    public String print(RangeValue value) {
        double displayValue = 0.0;
        displayValue = this.index == 0 ? value.getMin() : (this.index == 1 ? value.getMax() : value.getStep());
        return this.print("" + displayValue);
    }

    private String print(String value) {
        String result = "";
        if (this.rows == null || this.rows.equals("null") || this.rows.equals("1") || this.rows.equals("")) {
            result = "<input ";
            result = "true".equalsIgnoreCase(this.isPassword) ? result + "type='password' " : result + "type='text' ";
            result = result + (this.cols == null ? "" : "size='" + this.cols + "' ");
            result = result + "name='" + this.symbol + "' ";
            result = result + "value='" + value + "'/>\n";
        } else {
            result = "<textarea rows='" + this.rows + "' ";
            result = result + (this.cols == null ? "cols='20'" : "cols='" + this.cols + "' ");
            result = result + "name='" + this.symbol + "'>";
            result = result + value + "</textarea>";
        }
        return result;
    }
}

