/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jsp;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.nesc.rapid.jsp.JSPOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator
extends DefaultHandler {
    private SAXParser parser = null;
    private List<String> pageList = null;
    private String output = null;
    private String characters = null;
    private String pageName = null;
    private String pre = null;
    private String post = null;
    private String value = null;
    private String itemContents = null;
    private boolean refresh = false;
    private Stack<String> elementStack = null;
    private Stack<String> symbolStack = null;
    private List<String> replace = null;
    private boolean inSelection = false;
    private boolean inSubSelection = false;
    private String selection = null;
    private String index = null;
    private String variableName = null;
    private boolean isPortlet = true;
    private int pluginIndex = 0;

    public Generator() throws ParserConfigurationException {
        SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
        factory.setNamespaceAware(true);
        this.parser = factory.newSAXParser();
        this.pageList = new Vector<String>();
        this.elementStack = new Stack();
        this.symbolStack = new Stack();
    }

    public Generator(boolean isPortlet) throws ParserConfigurationException {
        this();
        this.isPortlet = isPortlet;
    }

    public List<String> getPageList() {
        return this.pageList;
    }

    public void generate(URL url) throws SAXException, IOException {
        this.parser.parse(url.getPath(), (DefaultHandler)this);
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.characters != null) {
            this.output = this.output + JSPOutput.insertVariables(this.characters);
            this.characters = null;
        }
        if (uri.equals("http://www.nesc.ac.uk/rapid")) {
            if (localName.equals("page")) {
                String name = attributes.getValue("name");
                this.pluginIndex = 0;
                this.pageName = name;
                this.output = "";
                this.output = this.output + JSPOutput.startPage(name, this.isPortlet);
            }
            if (this.pageName != null) {
                String size;
                if (localName.equals("fileupload") || localName.equals("variable") || localName.equals("selection") || localName.equals("button")) {
                    this.symbolStack.push(attributes.getValue("symbol"));
                }
                if (localName.equals("variable")) {
                    this.variableName = attributes.getValue("name");
                }
                if (this.inSelection && localName.equals("variable")) {
                    this.output = this.output + JSPOutput.startSelectionOutput(this.symbolStack.peek());
                }
                if (localName.equals("fileupload")) {
                    size = attributes.getValue("size");
                    String action = attributes.getValue("action");
                    this.output = this.output + JSPOutput.startFileUpload(this.symbolStack.peek(), size, action);
                }
                if (localName.equals("text") && this.symbolStack.peek() != null) {
                    String cols = attributes.getValue("cols");
                    if (cols == null) {
                        cols = "15";
                    }
                    String rows = attributes.getValue("rows");
                    this.index = attributes.getValue("index");
                    this.output = this.output + JSPOutput.startText(this.symbolStack.peek(), rows, cols, this.index, attributes.getValue("password"));
                }
                if (localName.equals("button")) {
                    String symbol = attributes.getValue("symbol");
                    String display = attributes.getValue("display");
                    this.output = this.output + JSPOutput.startButton(display, symbol, this.inSelection, this.inSubSelection);
                }
                if (localName.equals("list") && this.symbolStack.peek() != null) {
                    size = attributes.getValue("size");
                    this.refresh = false;
                    if (size == null) {
                        size = "10";
                    }
                    this.output = this.output + JSPOutput.startList(this.symbolStack.peek(), size, attributes.getValue("refresh"));
                }
                if (localName.equals("radio") || localName.equals("checkbox")) {
                    this.refresh = "true".equalsIgnoreCase(attributes.getValue("refresh"));
                    this.index = attributes.getValue("index");
                }
                if (localName.equals("item") && this.symbolStack.peek() != null) {
                    this.value = attributes.getValue("value");
                    this.itemContents = "";
                }
                if (localName.equals("output")) {
                    this.pre = "";
                    this.post = "";
                    this.replace = new Vector<String>();
                }
                if (localName.equals("replace")) {
                    this.replace.add(attributes.getValue("search"));
                    this.replace.add("");
                }
                if (localName.equals("browser") && this.symbolStack.peek() != null) {
                    String refresh = attributes.getValue("refresh");
                    String doubleclick = attributes.getValue("doubleclick");
                    this.output = this.output + JSPOutput.startBrowser(this.variableName, this.symbolStack.peek(), refresh, doubleclick);
                }
                if (localName.equals("selection") && this.symbolStack.peek() != null) {
                    this.output = this.inSubSelection ? this.output + JSPOutput.startSelectionSubJob(this.symbolStack.peek()) : this.output + JSPOutput.startSelection(this.symbolStack.peek(), attributes.getValue("type"));
                }
                if (localName.equals("joblist")) {
                    this.output = this.output + JSPOutput.startJobList();
                    this.inSelection = true;
                }
                if (localName.equals("plugin")) {
                    this.output = this.output + JSPOutput.startPlugin(this.pageName, this.pluginIndex);
                    ++this.pluginIndex;
                }
                if (localName.equals("subjoblist")) {
                    this.selection = attributes.getValue("selection");
                    this.output = this.output + JSPOutput.startSubJobList(this.selection);
                    this.inSelection = true;
                    this.inSubSelection = true;
                }
                if (localName.equals("jobid")) {
                    this.output = this.output + JSPOutput.startJobID();
                }
                if (localName.equals("status")) {
                    this.output = this.output + JSPOutput.startJobStatus();
                }
                if (localName.equals("date")) {
                    this.output = this.output + JSPOutput.startDate();
                }
                if (localName.equals("setjob")) {
                    this.inSelection = true;
                    this.output = this.output + JSPOutput.startSetJob(attributes.getValue("selection"));
                }
            }
            this.elementStack.push(localName);
        }
        if (uri.equals("http://www.w3.org/1999/xhtml")) {
            String xhtml = "";
            xhtml = xhtml + "<" + localName;
            for (int i = 0; i < attributes.getLength(); ++i) {
                xhtml = xhtml + " " + attributes.getQName(i) + "=\"" + JSPOutput.insertVariables(attributes.getValue(i)) + "\"";
            }
            xhtml = xhtml + ">";
            String element = this.elementStack.peek();
            if ("pre".equals(element)) {
                this.pre = this.pre + xhtml;
            } else if ("post".equals(element)) {
                this.post = this.post + xhtml;
            } else {
                this.output = this.output + xhtml;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String element = this.elementStack.peek();
        if ("page".equals(element) || "joblist".equals(element) || "checkbox".equals(element) || "radio".equals(element) || "setjob".equals(element)) {
            this.characters = this.characters == null ? new String(ch, start, length) : this.characters + new String(ch, start, length);
        }
        if ("pre".equals(element)) {
            this.pre = this.pre + new String(ch, start, length);
        }
        if ("post".equals(element)) {
            this.post = this.post + new String(ch, start, length);
        }
        if ("item".equals(element)) {
            this.itemContents = this.itemContents + new String(ch, start, length);
        }
        if ("replace".equals(element)) {
            this.replace.set(this.replace.size() - 1, new String(ch, start, length));
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qname) {
        if (this.characters != null) {
            this.output = this.output + JSPOutput.insertVariables(this.characters);
            this.characters = null;
        }
        if (uri.equals("http://www.nesc.ac.uk/rapid")) {
            this.elementStack.pop();
            if (this.pageName != null) {
                String symbol;
                if (localName.equals("page")) {
                    this.pageName = null;
                    this.output = this.output + JSPOutput.endPage();
                    this.pageList.add(JSPOutput.prettyPrint(this.output));
                }
                String string = symbol = this.symbolStack.size() == 0 ? null : this.symbolStack.peek();
                if (localName.equals("fileupload") || localName.equals("variable") || localName.equals("selection") || localName.equals("button")) {
                    this.symbolStack.pop();
                }
                if (localName.equals("joblist")) {
                    this.output = this.output + JSPOutput.endJobList();
                    this.inSelection = false;
                }
                if (localName.equals("subjoblist")) {
                    this.output = this.output + JSPOutput.endSubJobList(this.selection);
                    this.inSelection = false;
                    this.inSubSelection = false;
                }
                if (localName.equals("list")) {
                    this.output = this.output + JSPOutput.endList();
                }
                if (localName.equals("item")) {
                    this.output = this.output + JSPOutput.endItem(this.symbolStack.peek(), this.elementStack.peek(), this.value, this.refresh, this.itemContents, this.index);
                }
                if (localName.equals("output")) {
                    this.output = this.output + JSPOutput.endOutput(symbol, this.pre, this.post, this.replace);
                }
                if (localName.equals("setjob")) {
                    this.output = this.output + JSPOutput.endSetJob();
                    this.inSelection = false;
                }
                if (localName.equals("variable")) {
                    this.variableName = null;
                }
            }
        }
        if (uri.equals("http://www.w3.org/1999/xhtml")) {
            String element = this.elementStack.size() == 0 ? null : this.elementStack.peek();
            String xhtml = "</" + localName + ">";
            if ("pre".equals(element)) {
                this.pre = this.pre + xhtml;
            } else if ("post".equals(element)) {
                this.post = this.post + xhtml;
            } else {
                this.output = this.output + xhtml;
            }
        }
    }
}

