/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.jobmanager.bes;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.globus.myproxy.MyProxyException;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.data.filesystem.FileSystemConnector;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.job.EnvironmentVariable;
import uk.ac.nesc.rapid.job.Job;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobdata.VariableAnalysis;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.BESPlugin;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.BESState;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.SunGridEngineProperties;
import uk.ac.nesc.rapid.value.Value;

public class SunGridEnginePlugin
extends BESPlugin {
    private SunGridEngineProperties properties;
    private FileObject submitFileObject = null;

    public SunGridEnginePlugin(Job job, AbstractFileSystem fileSystem, SunGridEngineProperties properties) {
        super(job, fileSystem);
        this.properties = properties;
    }

    public String doSubmit(FileSystemConnector connector, int subJob) throws RapidException {
        try {
            JobData jobData = this.getJobData();
            this.submitFileObject = connector.connect(this.getFileSystem(), jobData, subJob);
            Value workingDirValue = this.getJob().getWorkingDir();
            if (workingDirValue != null && workingDirValue.size() > 0) {
                this.submitFileObject = this.submitFileObject.resolveFile(workingDirValue.resolve(jobData, subJob));
            }
            String jobWorkingDir = this.submitFileObject.getName().getPath();
            String subJobID = jobData.getJobID().getSubJobID(subJob);
            this.submitFileObject = this.submitFileObject.resolveFile(this.properties.getSubmitFileName() + subJobID);
            this.submitFileObject.createFile();
            FileContent submitFileContent = this.submitFileObject.getContent();
            OutputStream is = submitFileContent.getOutputStream();
            String submitFile = this.generateSubmitFile(jobData, jobWorkingDir, subJob);
            VariableAnalysis analysis = new VariableAnalysis(jobData);
            analysis.setInput(submitFile);
            submitFile = analysis.getOutput(subJob);
            is.write(submitFile.getBytes());
            is.close();
            String command = "export SGE_ROOT=" + this.properties.getSGERoot() + "; export ARCH=$$($SGE_ROOT/util/arch); ";
            command = command + "$SGE_ROOT/bin/$ARCH/qsub ";
            for (String option : this.properties.getQsubOptions()) {
                command = command + option + " ";
            }
            command = command + this.submitFileObject.getName().getPath();
            analysis.setInput(command);
            command = analysis.getOutput(subJob);
            String result = this.getFileSystem().execute(command, this.getJobData(), subJob);
            return this.getJobID(result);
        }
        catch (IOException ex) {
            throw new RapidException("Error connecting to filesystem " + this.getFileSystem().getName() + " : cause " + ex.getMessage());
        }
        catch (MyProxyException ex) {
            throw new RapidException("Unable to get MyProxy credential for filesystem " + this.getFileSystem().getName() + " : cause " + ex.getMessage());
        }
    }

    private String getJobID(String SGEOutput) throws RapidException {
        String[] subStrings = SGEOutput.split(" ");
        if (subStrings != null && subStrings.length == 7) {
            try {
                Integer.parseInt(subStrings[2]);
                return subStrings[2];
            }
            catch (NumberFormatException numberFormatException) {
                throw new RapidException("Could not parse SGE job ID: Message was: " + SGEOutput);
            }
        }
        throw new RapidException("Could not parse SGE job ID: Message was: " + SGEOutput);
    }

    public void updateStatus(int subJob) throws RapidException {
        JobData jobData = this.getJobData();
        BESState state = (BESState)jobData.getState();
        String[] remoteJobID = state.getRemoteJobID();
        if (subJob >= remoteJobID.length) {
            throw new RapidException("Remote Job ID as stored in JobSubmission does not contain " + subJob + " subjobs for Sun Grid Engine Plugin");
        }
        String command = "export SGE_ROOT=" + this.properties.getSGERoot() + "; export ARCH=$($SGE_ROOT/util/arch); ";
        command = command + "$SGE_ROOT/bin/$ARCH/qstat -xml -j " + remoteJobID[subJob];
        String result = this.getFileSystem().execute(command, this.getJobData(), subJob);
        if (result == null) {
            state.setPluginState(subJob, 5, "ERROR No result retrieved by executing '" + command + "'");
        } else if (result.contains("<unknown_jobs")) {
            state.setPluginState(subJob, 4);
        } else if (result.contains("<JB_ja_tasks>")) {
            state.setPluginState(subJob, 3);
        } else {
            state.setPluginState(subJob, 2);
        }
    }

    public void haltJob() throws Exception {
        JobData jobData = this.getJobData();
        BESState state = (BESState)jobData.getState();
        String[] remoteJobID = state.getRemoteJobID();
        for (int subJobIndex = 0; subJobIndex < remoteJobID.length; ++subJobIndex) {
            String command = "export SGE_ROOT=" + this.properties.getSGERoot() + "; export ARCH=$($SGE_ROOT/util/arch); ";
            command = command + "$SGE_ROOT/bin/$ARCH/qdel -f " + remoteJobID[subJobIndex];
            try {
                this.getFileSystem().execute(command, jobData, subJobIndex);
                continue;
            }
            catch (RapidException ex) {
                // empty catch block
            }
        }
    }

    private String generateSubmitFile(JobData jobData, String workingDir, int subJob) throws RapidException {
        Value stdoutValue;
        Value stdinValue;
        Value stderrValue;
        Collection<EnvironmentVariable> envCollection;
        String result = "#!/bin/sh\n";
        result = result + "#This is a submit file generated by the RAPID job submission system\n";
        for (String line : this.properties.getOptions()) {
            result = result + line + "\n";
        }
        if (workingDir != null) {
            result = result + "#$-wd " + workingDir + "\n";
        }
        if ((envCollection = this.getJob().getEnvironmentVariableCollection()).size() > 0) {
            result = result + "#$-v ";
            int index = 0;
            for (EnvironmentVariable env : envCollection) {
                result = result + env.getName().resolve(jobData, subJob) + "=" + env.getValue().resolve(jobData, subJob);
                if (++index == envCollection.size()) continue;
                result = result + ",";
            }
            result = result + "\n";
        }
        if ((stderrValue = this.getJob().getStderr()).size() > 0) {
            result = result + "#$-e " + stderrValue.resolve(jobData, subJob) + "\n";
        }
        if ((stdinValue = this.getJob().getStdin()).size() > 0) {
            result = result + "#$-i " + stdinValue.resolve(jobData, subJob) + "\n";
        }
        if ((stdoutValue = this.getJob().getStdout()).size() > 0) {
            result = result + "#$-o " + stdoutValue.resolve(jobData, subJob) + "\n";
        }
        result = result + this.getJob().getExecutable().resolve(jobData, subJob) + " ";
        for (Value arg : this.getJob().getParameterList()) {
            result = result + arg.resolve(jobData, subJob) + " ";
        }
        result = result + "\n";
        return result;
    }

    protected void doCleanUp() throws RapidException {
        if (this.submitFileObject != null) {
            try {
                this.submitFileObject.delete();
            }
            catch (FileSystemException ex) {
                throw new RapidException("Error cleaning files in SunGrid Engine plugin! " + ex.getMessage());
            }
        }
    }
}

