/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.jobmanager.bes;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.data.filesystem.FileSystemConnector;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.job.Job;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.BESPlugin;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.ForkProperties;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.ForkThread;

public class ForkPlugin
extends BESPlugin {
    ForkProperties properties;
    Map<String, ForkThread> threadMap = new HashMap<String, ForkThread>();

    public ForkPlugin(Job job, AbstractFileSystem fileSystem, ForkProperties properties) {
        super(job, fileSystem);
        this.properties = properties;
    }

    protected void updateStatus(int subJob) throws RapidException {
    }

    public String toString() {
        return "FORK " + super.toString();
    }

    public String doSubmit(FileSystemConnector connector, int subJob) {
        ForkThread newThread = new ForkThread(this.getJobData(), this.getJob(), subJob, this.getFileSystem(), connector, this.properties);
        String uuid = UUID.randomUUID().toString();
        this.threadMap.put(uuid, newThread);
        new Thread(newThread).start();
        return uuid;
    }

    public void haltJob() throws Exception {
    }

    protected void doCleanUp() throws RapidException {
        Set<String> uuidSet = this.threadMap.keySet();
        for (String uuid : uuidSet) {
            this.threadMap.get(uuid).doCleanUp();
        }
    }
}

