/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.jobmanager.bes;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.globus.myproxy.MyProxyException;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.data.filesystem.FileSystemConnector;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.job.EnvironmentVariable;
import uk.ac.nesc.rapid.job.Job;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.BESPlugin;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.BESState;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.CondorProperties;
import uk.ac.nesc.rapid.value.Value;

public class CondorPlugin
extends BESPlugin {
    private CondorProperties properties;
    private FileObject submissionFile = null;

    public CondorPlugin(Job job, AbstractFileSystem fileSystem, CondorProperties properties) {
        super(job, fileSystem);
        this.properties = properties;
    }

    public String doSubmit(FileSystemConnector connector, int subJob) throws RapidException {
        try {
            FileObject submitFileObject = connector.connect(this.getFileSystem(), this.getJobData(), subJob);
            Value workingDirValue = this.getJob().getWorkingDir();
            if (workingDirValue.size() != 0) {
                submitFileObject = submitFileObject.resolveFile(workingDirValue.resolve(this.getJobData(), subJob));
            }
            String subJobID = this.getJobData().getJobID().getSubJobID(subJob);
            submitFileObject = submitFileObject.resolveFile(this.properties.getSubmitFileName() + subJobID);
            submitFileObject.createFile();
            FileContent submitFileContent = submitFileObject.getContent();
            OutputStream is = submitFileContent.getOutputStream();
            is.write(this.generateSubmitFile(subJob).getBytes());
            is.close();
            String command = "";
            if (this.properties.getCondorConfig() != null) {
                command = command + "export CONDOR_CONFIG=" + this.properties.getCondorConfig() + "; ";
            }
            command = command + "export PATH=$PATH:" + this.properties.getBinDirectory() + "; ";
            command = command + this.properties.getBinDirectory() + "/" + "condor_submit" + " " + submitFileObject.getName().getPath();
            this.submissionFile = submitFileObject;
            String result = this.getFileSystem().execute(command, this.getJobData(), subJob);
            return this.getJobID(result);
        }
        catch (IOException ex) {
            throw new RapidException("Error connecting to filesystem " + this.getFileSystem().getName() + " : cause " + ex.getMessage());
        }
        catch (MyProxyException ex) {
            throw new RapidException("Unable to get MyProxy credential for filesystem " + this.getFileSystem().getName() + " : cause " + ex.getMessage());
        }
    }

    public void updateStatus(int subJob) throws RapidException {
        JobData jobData = this.getJobData();
        BESState state = (BESState)jobData.getState();
        String[] remoteJobID = state.getRemoteJobID();
        if (subJob >= remoteJobID.length) {
            throw new RapidException("Remote Job ID as stored in JobSubmission does not contain " + subJob + " subjobs for Condor Plugin");
        }
        String command = "";
        if (this.properties.getCondorConfig() != null) {
            command = "export CONDOR_CONFIG=" + this.properties.getCondorConfig() + "; ";
        }
        command = command + "export PATH=$PATH:" + this.properties.getBinDirectory() + "; ";
        command = command + "condor_q " + remoteJobID[subJob] + " -xml";
        String classad = this.getFileSystem().execute(command, this.getJobData(), subJob);
        Pattern varPattern = Pattern.compile("<a n=\"JobStatus\"><i>\\d</i></a>");
        Matcher varMatch = varPattern.matcher(classad);
        if (varMatch.find()) {
            String jobStatusLine = classad.substring(varMatch.start(), varMatch.end());
            if (jobStatusLine == null || jobStatusLine.length() != 29) {
                throw new RapidException("Condor returned a classadd without a job status field.");
            }
            char jobStatusID = jobStatusLine.charAt(20);
            switch (jobStatusID) {
                case '1': {
                    state.setPluginState(subJob, 2);
                    break;
                }
                case '2': {
                    state.setPluginState(subJob, 3);
                    break;
                }
                case '5': {
                    state.setPluginState(subJob, 5, "Condor Error - Job is suspended!");
                    break;
                }
                default: {
                    throw new RapidException("Error retrieving job status from Condor ClassAd: State: " + jobStatusID);
                }
            }
        } else {
            state.setPluginState(subJob, 4);
        }
    }

    public void haltJob() throws Exception {
        JobData jobData = this.getJobData();
        BESState state = (BESState)jobData.getState();
        String[] remoteJobID = state.getRemoteJobID();
        for (int subJobIndex = 0; subJobIndex < remoteJobID.length; ++subJobIndex) {
            String command = "";
            if (this.properties.getCondorConfig() != null) {
                command = command + "export CONDOR_CONFIG=" + this.properties.getCondorConfig() + "; ";
            }
            command = command + "export PATH=$PATH:" + this.properties.getBinDirectory() + "; ";
            command = command + this.properties.getBinDirectory() + "/" + "condor_submit" + " " + remoteJobID[subJobIndex] + "\n";
            try {
                this.getFileSystem().execute(command, jobData, subJobIndex);
                continue;
            }
            catch (RapidException ex) {
                // empty catch block
            }
        }
    }

    private String getJobID(String condorOutput) {
        int start = condorOutput.lastIndexOf(" ");
        if (start > 0) {
            return condorOutput.substring(start, condorOutput.length() - 1);
        }
        return "ERROR";
    }

    private String generateSubmitFile(int subJob) throws RapidException {
        Collection<EnvironmentVariable> envCollection;
        StringBuffer result = new StringBuffer();
        if (this.properties.getUniverse() != null) {
            result.append("Universe = " + this.properties.getUniverse() + "\n");
        }
        for (String line : this.properties.getSubmitFileLines()) {
            result.append(line + "\n");
        }
        JobData data = this.getJobData();
        Value workingDir = this.getJob().getWorkingDir();
        if (workingDir != null && workingDir.size() > 0) {
            result.append("Initialdir = " + workingDir.resolve(this.getJobData(), subJob) + "\n");
        }
        if ((envCollection = this.getJob().getEnvironmentVariableCollection()).size() > 0) {
            result.append("Environment = \"");
            int index = 0;
            for (EnvironmentVariable env : envCollection) {
                result.append(env.getName().resolve(data, subJob) + "=" + env.getValue().resolve(data, subJob));
                if (++index == envCollection.size()) continue;
                result.append(";");
            }
            result.append("\"\n");
        }
        if (this.getJob().getParameterList().size() > 0) {
            result.append("Arguments = ");
            for (Value arg : this.getJob().getParameterList()) {
                result.append(arg.resolve(data, subJob) + " ");
            }
            result.append("\n");
        }
        if (this.getJob().getStderr() != null) {
            result.append("Error = " + this.getJob().getStderr().resolve(data, subJob) + "\n");
        }
        if (this.getJob().getStdin() != null) {
            result.append("Input = " + this.getJob().getStdin().resolve(data, subJob) + "\n");
        }
        if (this.getJob().getStdout() != null) {
            result.append("Output = " + this.getJob().getStdout().resolve(data, subJob) + "\n");
        }
        result.append("Executable = " + this.getJob().getExecutable().resolve(data, subJob) + "\n");
        result.append("Queue\n");
        return result.toString();
    }

    protected void doCleanUp() throws RapidException {
        try {
            if (this.submissionFile != null) {
                this.submissionFile.delete();
            }
        }
        catch (FileSystemException ex) {
            throw new RapidException("FileSystem Error when cleaning up Condor submit file: " + ex.getMessage());
        }
    }
}

