/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.jobmanager.bes;

import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.data.filesystem.FileSystemConnector;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.job.Job;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.BESState;

public abstract class BESPlugin {
    private Job job = null;
    private JobData jobData = null;
    private AbstractFileSystem fileSystem = null;

    BESPlugin(Job job, AbstractFileSystem fileSystem) {
        this.job = job;
        this.fileSystem = fileSystem;
    }

    public void setJobData(JobData jobData) {
        this.jobData = jobData;
    }

    public final synchronized void doSubmit(FileSystemConnector connector) throws RapidException {
        if (this.jobData == null) {
            throw new RapidException("Job Data has not been set in plugin");
        }
        BESState jobState = (BESState)this.jobData.getState();
        int numberOfSubJobs = this.jobData.getNumberOfSubJobs();
        String[] newSubJobIDArray = new String[numberOfSubJobs];
        for (int subJob = 0; subJob < numberOfSubJobs; ++subJob) {
            jobState.setPluginState(subJob, 1);
            newSubJobIDArray[subJob] = this.doSubmit(connector, subJob);
        }
        jobState.setRemoteJobID(newSubJobIDArray);
    }

    protected abstract String doSubmit(FileSystemConnector var1, int var2) throws RapidException;

    protected abstract void doCleanUp() throws RapidException;

    protected abstract void updateStatus(int var1) throws RapidException;

    public final synchronized void updateStatus() throws RapidException {
        for (int subJob = 0; subJob < this.getJobData().getNumberOfSubJobs(); ++subJob) {
            BESState jobState = (BESState)this.jobData.getState();
            int currentState = jobState.getPluginState(subJob);
            if (currentState == 5 || currentState == 4) continue;
            this.updateStatus(subJob);
        }
    }

    public Job getJob() {
        return this.job;
    }

    public AbstractFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public JobData getJobData() {
        return this.jobData;
    }

    public abstract void haltJob() throws Exception;

    public String toString() {
        String result = "BES Plugin: \n";
        return result;
    }
}

