/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.jobmanager.bes;

import java.util.Set;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemException;
import org.globus.myproxy.MyProxyException;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.data.filesystem.FileSystemTable;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.job.CreationFlag;
import uk.ac.nesc.rapid.job.DataStage;
import uk.ac.nesc.rapid.job.DataStageURL;
import uk.ac.nesc.rapid.job.DoTarget;
import uk.ac.nesc.rapid.job.Job;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.JobManager;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.JobState;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.BESPlugin;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.BESProperties;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.BESState;
import uk.ac.nesc.rapid.persistence.JobPersistence;
import uk.ac.nesc.rapid.value.Value;
import uk.ac.nesc.rapid.value.impl.JobIDValue;
import uk.ac.nesc.rapid.value.impl.SingleValue;

public class BESJobManager
extends JobManager {
    private String fileSystemName = null;
    private BESPlugin plugin = null;
    private boolean jobHalted = false;

    public BESJobManager(Job job, FileSystemTable fileSystemTable, BESProperties properties) {
        super(job, fileSystemTable);
        this.fileSystemName = properties.getFileSystemName();
    }

    public String getFileSystemName() {
        return this.fileSystemName;
    }

    public void setFileSystemName(String fileSystemName) {
        this.fileSystemName = fileSystemName;
    }

    public BESPlugin getBESPlugin() {
        return this.plugin;
    }

    public void setBESPlugin(BESPlugin executionHost) {
        this.plugin = executionHost;
    }

    public void setJobHalted() {
        this.jobHalted = true;
    }

    public boolean isJobHalted() {
        return this.jobHalted;
    }

    private void doSourceFileTransfers(AbstractFileSystem destinationFileSystem) throws RapidException {
        try {
            JobData jobData = this.getJobData();
            Set<String> dataStageSet = this.getJob().getDataStages();
            for (String dataStageName : dataStageSet) {
                DataStage dataStage = this.getJob().getDataStage(dataStageName);
                Value fileNameValue = dataStage.getFileName();
                if (!dataStage.existsSourceURL()) continue;
                DataStageURL dataStageURL = dataStage.getSourceURL();
                Value sourceFileSystemValue = dataStageURL.getFileSystem();
                Value sourcePathValue = dataStageURL.getPath();
                int numberOfFileTransfers = Math.max(sourceFileSystemValue.resolveSize(jobData), sourcePathValue.resolveSize(jobData));
                numberOfFileTransfers = Math.max(numberOfFileTransfers, fileNameValue.resolveSize(jobData));
                for (int fileTransfer = 0; fileTransfer < numberOfFileTransfers; ++fileTransfer) {
                    String sourceFileSystemName = dataStageURL.getFileSystem().resolve(jobData, fileTransfer);
                    AbstractFileSystem sourceFileSystem = this.getFileSystemTable().getFileSystem(sourceFileSystemName);
                    FileObject sourceFileObject = this.getFileSystemTable().getFileSystemConnector().connect(sourceFileSystem, jobData, fileTransfer);
                    String sourcePath = dataStageURL.getPath().resolve(jobData, fileTransfer);
                    sourceFileObject = sourceFileObject.resolveFile(sourcePath);
                    FileObject destinationFileObject = this.getFileSystemTable().getFileSystemConnector().connect(destinationFileSystem, jobData, fileTransfer);
                    Value workingDirValue = this.getJob().getWorkingDir();
                    if (workingDirValue.size() != 0) {
                        String workingDir = this.getJob().getWorkingDir().resolve(jobData, fileTransfer);
                        destinationFileObject = destinationFileObject.resolveFile(workingDir);
                    }
                    if (dataStage.getFileName().size() != 0) {
                        String fileName = dataStage.getFileName().resolve(jobData, fileTransfer);
                        destinationFileObject = destinationFileObject.resolveFile(fileName);
                    }
                    String creationFlag = dataStage.getCreationFlag().resolve(jobData, fileTransfer);
                    if (!destinationFileObject.exists() || CreationFlag.OVERWRITE.toString().equals(creationFlag)) {
                        destinationFileObject.copyFrom(sourceFileObject, (FileSelector)new AllFileSelector());
                    }
                    destinationFileObject.close();
                    sourceFileObject.close();
                }
            }
        }
        catch (FileSystemException ex) {
            throw new RapidException("File System Error in Source file transfer! : " + ex.getMessage());
        }
        catch (MyProxyException ex) {
            throw new RapidException("Error obtaining myproxy credentials in Source Transfer : " + ex.getMessage());
        }
    }

    private void doTargetFileTransfers(AbstractFileSystem sourceFileSystem) throws RapidException {
        try {
            JobData jobData = this.getJobData();
            BESState jobState = (BESState)jobData.getState();
            Set<String> dataStageSet = this.getJob().getDataStages();
            for (String dataStageName : dataStageSet) {
                DataStage dataStage = this.getJob().getDataStage(dataStageName);
                Value fileNameValue = dataStage.getFileName();
                Value doTarget = dataStage.getDoTarget();
                if (!dataStage.existsTargetURL()) continue;
                DataStageURL dataStageURL = dataStage.getTargetURL();
                Value targetFileSystemValue = dataStageURL.getFileSystem();
                Value targetPathValue = dataStageURL.getPath();
                int numberOfFileTransfers = Math.max(targetFileSystemValue.resolveSize(jobData), targetPathValue.resolveSize(jobData));
                numberOfFileTransfers = Math.max(numberOfFileTransfers, fileNameValue.resolveSize(jobData));
                for (int fileTransfer = 0; fileTransfer < numberOfFileTransfers; ++fileTransfer) {
                    String doTargetString = doTarget.get(fileTransfer);
                    boolean doFileTransfer = DoTarget.ALWAYS.name().equalsIgnoreCase(doTargetString);
                    doFileTransfer = doFileTransfer || DoTarget.ONSUCCESS.name().equalsIgnoreCase(doTargetString) && jobState.getState() == 5;
                    boolean bl = doFileTransfer = doFileTransfer || DoTarget.ONFAILURE.name().equalsIgnoreCase(doTargetString) && jobState.getState() != 5;
                    if (!doFileTransfer) continue;
                    FileObject sourceFileObject = this.getFileSystemTable().getFileSystemConnector().connect(sourceFileSystem, jobData, fileTransfer);
                    if (this.getJob().getWorkingDir().size() != 0) {
                        String workingDir = this.getJob().getWorkingDir().resolve(jobData, fileTransfer);
                        sourceFileObject = sourceFileObject.resolveFile(workingDir);
                    }
                    if (dataStage.getFileName().size() != 0) {
                        String fileName = dataStage.getFileName().resolve(jobData, fileTransfer);
                        sourceFileObject = sourceFileObject.resolveFile(fileName);
                    }
                    String destinationFileSystemName = dataStageURL.getFileSystem().resolve(jobData, fileTransfer);
                    AbstractFileSystem destinationFileSystem = this.getFileSystemTable().getFileSystem(destinationFileSystemName);
                    FileObject destinationFileObject = this.getFileSystemTable().getFileSystemConnector().connect(destinationFileSystem, jobData, fileTransfer);
                    String destinationPath = dataStageURL.getPath().resolve(jobData, fileTransfer);
                    destinationFileObject = destinationFileObject.resolveFile(destinationPath);
                    destinationFileObject.copyFrom(sourceFileObject, (FileSelector)new AllFileSelector());
                    destinationFileObject.close();
                    sourceFileObject.close();
                }
            }
        }
        catch (FileSystemException ex) {
            throw new RapidException("File System Error in Source file transfer! : " + ex.getMessage());
        }
        catch (MyProxyException ex) {
            throw new RapidException("Error obtaining myproxy credentials in Source Transfer : " + ex.getMessage());
        }
    }

    private void doCleanUp(AbstractFileSystem fileSystem) throws RapidException {
        try {
            JobData jobData = this.getJobData();
            Set<String> dataStageSet = this.getJob().getDataStages();
            for (String dataStageName : dataStageSet) {
                DataStage dataStage = this.getJob().getDataStage(dataStageName);
                if (!dataStage.isDeleteOnTermination()) continue;
                int numberOfFiles = dataStage.getFileName().resolveSize(jobData);
                for (int fileIndex = 0; fileIndex < numberOfFiles; ++fileIndex) {
                    FileObject fileObject = this.getFileSystemTable().getFileSystemConnector().connect(fileSystem, jobData, fileIndex);
                    if (this.getJob().getWorkingDir().size() != 0) {
                        String workingDir = this.getJob().getWorkingDir().resolve(jobData, fileIndex);
                        fileObject = fileObject.resolveFile(workingDir);
                    }
                    if (dataStage.getFileName().size() != 0) {
                        String fileName = dataStage.getFileName().resolve(jobData, fileIndex);
                        fileObject = fileObject.resolveFile(fileName);
                    }
                    if (!fileObject.exists()) continue;
                    fileObject.delete((FileSelector)new AllFileSelector());
                }
            }
            if (this.plugin != null) {
                this.plugin.doCleanUp();
            }
        }
        catch (FileSystemException ex) {
            throw new RapidException("File System Error in Cleanup! : " + ex.getMessage());
        }
        catch (MyProxyException ex) {
            throw new RapidException("Error obtaining myproxy credentials in Cleanup! : " + ex.getMessage());
        }
    }

    public Value monitor() {
        JobState jobState = this.getJobData().getState();
        if (jobState == null) {
            return new SingleValue("Initialising");
        }
        return ((BESState)jobState).getMessage();
    }

    public void run() {
        this.getBESPlugin().setJobData(this.getJobData());
        if (this.getJobData().getState() == null) {
            this.getJobData().setState(new BESState());
        }
        BESState jobState = (BESState)this.getJobData().getState();
        AbstractFileSystem fileSystem = null;
        try {
            fileSystem = this.getFileSystemTable().getFileSystem(this.getFileSystemName());
        }
        catch (RapidException ex) {
            jobState.setState(8, "Unknown filesystem definition" + ex.getMessage());
        }
        boolean besDone = false;
        while (!besDone) {
            switch (jobState.getState()) {
                case 0: {
                    jobState.setState(1);
                    break;
                }
                case 1: {
                    try {
                        this.doSourceFileTransfers(fileSystem);
                        jobState.setState(2);
                    }
                    catch (RapidException ex) {
                        jobState.setState(8, "Error in Source Transfer: " + ex.getMessage());
                    }
                    break;
                }
                case 2: {
                    try {
                        this.plugin.doSubmit(this.getFileSystemTable().getFileSystemConnector());
                        jobState.setState(3);
                    }
                    catch (RapidException ex) {
                        jobState.setState(8, "Error Executing job : " + ex.getMessage());
                    }
                    break;
                }
                case 3: {
                    boolean done = false;
                    jobState.setPluginActive(true);
                    while (!done) {
                        try {
                            Thread.sleep(2000L);
                            if (this.isJobHalted()) {
                                done = true;
                                continue;
                            }
                            this.plugin.updateStatus();
                            done = jobState.pluginDone();
                        }
                        catch (InterruptedException ex) {
                            done = true;
                            jobState.setState(8, "Submission thread was interrupted: " + ex.getMessage());
                            jobState.setPluginActive(false);
                            return;
                        }
                        catch (RapidException ex) {
                            done = true;
                            jobState.setState(8, "Error retrieving status: " + ex.getMessage());
                            jobState.setPluginActive(false);
                            return;
                        }
                    }
                    if (jobState.pluginError()) {
                        jobState.setState(8, "Error in job submission...");
                        break;
                    }
                    if (this.isJobHalted()) {
                        jobState.setState(4);
                        break;
                    }
                    jobState.setPluginActive(false);
                    jobState.setState(5);
                    break;
                }
                case 5: {
                    try {
                        this.doTargetFileTransfers(fileSystem);
                    }
                    catch (RapidException ex) {
                        jobState.setState(8, "Error in Target Transfer: " + ex.getMessage());
                    }
                    jobState.setState(6);
                    break;
                }
                case 6: {
                    try {
                        this.doCleanUp(fileSystem);
                        jobState.setState(7);
                        if (this.getPostProcessor() == null) break;
                        this.getPostProcessor().doPostProcess(JobIDValue.getJobID(this.getJobData().getJobID().get()));
                    }
                    catch (RapidException ex) {
                        jobState.setState(8, "Error in Cleanup: " + ex.getMessage());
                    }
                    break;
                }
                case 4: {
                    jobState.setPluginActive(false);
                    try {
                        this.plugin.haltJob();
                    }
                    catch (Exception ex) {
                        jobState.setState(8, "Error halting job: " + ex.getMessage());
                        jobState.setPluginActive(false);
                        return;
                    }
                    jobState.setState(9);
                    break;
                }
                case 8: 
                case 9: {
                    try {
                        this.doTargetFileTransfers(fileSystem);
                        this.doCleanUp(fileSystem);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    besDone = true;
                    break;
                }
                case 7: {
                    besDone = true;
                    break;
                }
                default: {
                    jobState.setState(8, "Unknown State");
                    besDone = true;
                }
            }
            try {
                if (!this.getJobData().isDoPersist()) continue;
                JobPersistence.updateJobData(this.getJobData());
            }
            catch (RapidException ex) {
                jobState.setState(8, "Error persisting job! " + ex.getMessage());
            }
        }
    }
}

