/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.jobmanager;

import uk.ac.nesc.rapid.data.filesystem.FileSystemTable;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.job.Job;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.PostProcessor;
import uk.ac.nesc.rapid.value.Value;

public abstract class JobManager
implements Runnable {
    private Job job;
    private FileSystemTable fileSystemTable;
    private JobData jobData;
    private PostProcessor postProcessor = null;

    public abstract Value monitor();

    public abstract void setJobHalted();

    public JobManager(Job job, FileSystemTable fileSystemTable) {
        this.job = job;
        this.fileSystemTable = fileSystemTable;
    }

    public final void setJobData(JobData data) {
        this.jobData = data;
    }

    public final JobData getJobData() {
        return this.jobData;
    }

    public FileSystemTable getFileSystemTable() {
        return this.fileSystemTable;
    }

    public Job getJob() {
        return this.job;
    }

    public void setPostProcessor(PostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    public PostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    public void runJob() throws RapidException {
        if (this.jobData == null) {
            throw new RapidException("No Job Data Set when running job");
        }
        this.jobData.finalise(this.job);
        Thread thread = new Thread(this);
        thread.start();
    }
}

