/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.impl;

import java.util.HashMap;
import java.util.Map;
import uk.ac.nesc.rapid.data.filesystem.FileSystemTable;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.job.Job;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobsubmission.JobQueue;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.JobManager;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.JobManagerFactory;

public class JobQueueImpl
implements JobQueue {
    private JobManagerFactory factory;
    private Map<String, JobManager> managerMap = new HashMap<String, JobManager>();
    private Job job = null;
    private FileSystemTable fileSystemTable = null;

    public JobQueueImpl(Job job, FileSystemTable fileSystemTable, JobManagerFactory factory) {
        this.factory = factory;
        this.fileSystemTable = fileSystemTable;
        this.job = job;
    }

    public JobManager addJob(JobData data) throws RapidException {
        JobManager manager = this.factory.newInstance(this.job, this.fileSystemTable);
        manager.setJobData(data);
        this.managerMap.put(data.getJobID().getJobID(), manager);
        return manager;
    }

    public JobManager getJob(JobData data) throws RapidException {
        String jobID = data.getJobID().getJobID();
        JobManager manager = this.managerMap.get(jobID);
        if (manager == null) {
            String error = "No Job with job ID " + jobID + " in job queue " + this.factory.toString() + " when trying to get a job ";
            error = error + "IDs available: ";
            for (String id : this.managerMap.keySet()) {
                error = error + id + " ; ";
            }
            throw new RapidException(error);
        }
        return manager;
    }

    public void removeJob(JobData data) throws RapidException {
        String jobID = data.getJobID().getJobID();
        JobManager manager = this.managerMap.get(jobID);
        if (manager == null) {
            throw new RapidException("No Job with job ID " + jobID + " in Job Manager when trying to remove a job");
        }
        this.managerMap.remove(jobID);
    }
}

