/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobdata;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableAnalysis {
    private String input = null;
    private List<VariableLocation> variableLocations = null;
    private JobData table = null;

    public VariableAnalysis(JobData table) {
        this.table = table;
    }

    public void setVariableTable(JobData table) {
        this.table = table;
    }

    public synchronized void setInput(String input) {
        this.input = input;
        this.analyse();
    }

    public int getNumberOfVariables() {
        return this.variableLocations.size();
    }

    public List<Value> getVariables() throws RapidException {
        Vector<Value> result = new Vector<Value>();
        for (VariableLocation location : this.variableLocations) {
            result.add(this.table.getVariable(location.getName()));
        }
        return result;
    }

    public Collection<String> getVariableNames() {
        Vector<String> result = new Vector<String>();
        for (VariableLocation location : this.variableLocations) {
            result.add(location.getName());
        }
        return result;
    }

    public String getOutput(int subJob) throws RapidException {
        StringBuffer result = new StringBuffer();
        int start = 0;
        for (VariableLocation location : this.variableLocations) {
            result.append(this.input.substring(start, location.start));
            result.append(this.table.getVariable(location.getName()).get(subJob));
            start = location.getEnd();
        }
        result.append(this.input.substring(start, this.input.length()));
        return result.toString().replace("$$", "$");
    }

    private void analyse() {
        Pattern varPattern = Pattern.compile("(\\$)+\\([^ \\)]*\\)");
        Matcher varMatch = varPattern.matcher(this.input);
        this.variableLocations = new Vector<VariableLocation>();
        while (varMatch.find()) {
            int start = varMatch.start();
            String var = varMatch.group();
            while (var.startsWith("$$")) {
                var = var.substring(2);
                start += 2;
            }
            if (!var.startsWith("$(")) continue;
            this.variableLocations.add(new VariableLocation(var.substring(2, var.length() - 1), start, varMatch.end()));
        }
    }

    private class VariableLocation {
        String name;
        int start;
        int end;

        public VariableLocation(String name, int start, int end) {
            this.name = name;
            this.start = start;
            this.end = end;
        }

        public String getName() {
            return this.name;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

