/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobdata;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobdata.JobDataTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobDataTableImpl
implements JobDataTable {
    Map<String, JobData> values = new HashMap<String, JobData>();

    @Override
    public JobData getJobData(String jobID) throws RapidException {
        JobData table = this.values.get(jobID);
        if (table == null) {
            throw new RapidException("No Job with job ID " + jobID + " in table");
        }
        return table;
    }

    @Override
    public boolean exists(String jobID) {
        return this.values.containsKey(jobID);
    }

    @Override
    public Set<String> getJobIDSet() {
        return this.values.keySet();
    }

    @Override
    public void delete(String jobID) throws RapidException {
        if (this.values.get(jobID) == null) {
            throw new RapidException("Could not find job with ID " + jobID + " in table when attempting to delete a job");
        }
        this.values.remove(jobID);
    }

    @Override
    public void addJobData(JobData jobData) {
        this.values.put(jobData.getJobID().getJobID(), jobData);
    }

    public String toString() {
        String result = "\nJob Data Table\n";
        for (String id : this.values.keySet()) {
            result = result + this.values.get(id);
        }
        return result;
    }
}

