/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.job;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.JobDataTable;
import uk.ac.nesc.rapid.value.Value;
import uk.ac.nesc.rapid.value.impl.JobIDValue;

public class GlobalVariableTable {
    private Map<String, Value> globalVariableMap = new HashMap<String, Value>();

    public Value getGlobalVariable(String name) throws RapidException {
        Value result = this.globalVariableMap.get(name);
        if (result == null) {
            throw new RapidException("No Global Variable named '" + name + "'");
        }
        return result;
    }

    public void setGlobalVariable(String name, Value value) {
        this.globalVariableMap.put(name, value);
    }

    public boolean exists(String name) {
        return this.globalVariableMap.containsKey(name);
    }

    public void initialise(JobDataTable jobDataTable) throws RapidException {
        for (String selection : this.globalVariableMap.keySet()) {
            Iterator<String> jobIDIterator;
            Value jobIDValue = this.getGlobalVariable(selection);
            String subJobID = jobIDValue.get();
            if (JobIDValue.isWellFormedSubJobID(subJobID) && jobDataTable.exists(JobIDValue.getJobID(subJobID)) || !(jobIDIterator = jobDataTable.getJobIDSet().iterator()).hasNext()) continue;
            jobIDValue.put(jobIDIterator.next());
        }
    }
}

