/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.impl;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import uk.ac.nesc.rapid.button.Button;
import uk.ac.nesc.rapid.button.ButtonTable;
import uk.ac.nesc.rapid.data.RapidConfiguration;
import uk.ac.nesc.rapid.data.RapidData;
import uk.ac.nesc.rapid.data.browser.FileBrowserTable;
import uk.ac.nesc.rapid.data.filesystem.FileSystemConnector;
import uk.ac.nesc.rapid.data.filesystem.FileSystemTable;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.job.GlobalVariableTable;
import uk.ac.nesc.rapid.job.Job;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobdata.JobDataImpl;
import uk.ac.nesc.rapid.jobdata.JobDataTable;
import uk.ac.nesc.rapid.jobdata.JobDataTableImpl;
import uk.ac.nesc.rapid.jobsubmission.JobQueueTable;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.JobManager;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.ActionPostProcessor;
import uk.ac.nesc.rapid.persistence.JobPersistence;
import uk.ac.nesc.rapid.plugin.PluginTable;
import uk.ac.nesc.rapid.plugin.PluginTableImpl;
import uk.ac.nesc.rapid.plugin.RapidPlugin;
import uk.ac.nesc.rapid.symbol.SymbolTable;
import uk.ac.nesc.rapid.value.impl.JobIDValue;
import uk.ac.nesc.rapid.xml.ButtonTableReader;
import uk.ac.nesc.rapid.xml.FileBrowserReader;
import uk.ac.nesc.rapid.xml.FileSystemReader;
import uk.ac.nesc.rapid.xml.GlobalVariableReader;
import uk.ac.nesc.rapid.xml.JobQueueReader;
import uk.ac.nesc.rapid.xml.JobReader;
import uk.ac.nesc.rapid.xml.PersistenceReader;
import uk.ac.nesc.rapid.xml.PluginReader;
import uk.ac.nesc.rapid.xml.RapidConfigurationReader;
import uk.ac.nesc.rapid.xml.SymbolTableReader;

public class RapidDataImpl
implements RapidData {
    private SymbolTable symbolTable = null;
    private Job job = null;
    private JobDataTable jobDataTable = null;
    private JobData jobData = null;
    private JobQueueTable jobQueueTable = null;
    private FileBrowserTable fileBrowserTable = null;
    private FileSystemTable fileSystemTable = null;
    private ButtonTable buttonTable = null;
    private RapidConfiguration rapidConfiguration = null;
    private PluginTable pluginTable = null;
    private GlobalVariableTable globalVariableTable = null;
    private String page = null;
    private String userName = null;
    private FileSystemConnector fileSystemConnector = null;

    public RapidDataImpl(URL xmlFile, URL pluginDirectory, String userName) throws IOException, SAXException, RapidException, ParserConfigurationException {
        List<RapidPlugin> pluginList;
        this.symbolTable = SymbolTableReader.read(xmlFile);
        this.job = JobReader.read(xmlFile);
        this.fileSystemTable = FileSystemReader.read(xmlFile);
        this.jobQueueTable = JobQueueReader.read(xmlFile, this.job, this.fileSystemTable);
        this.rapidConfiguration = RapidConfigurationReader.read(xmlFile);
        this.fileBrowserTable = FileBrowserReader.read(xmlFile);
        this.buttonTable = ButtonTableReader.read(xmlFile);
        this.globalVariableTable = GlobalVariableReader.read(xmlFile);
        this.pluginTable = pluginDirectory == null ? new PluginTableImpl() : PluginReader.read(xmlFile, pluginDirectory);
        if (userName == null) {
            this.jobDataTable = new JobDataTableImpl();
        } else {
            PersistenceReader.read(xmlFile);
            if (JobPersistence.getDbms() != null) {
                JobPersistence.startDatabase();
                this.jobDataTable = JobPersistence.loadJobDataTable(userName);
                JobPersistence.restartJobSubmissions(this.jobQueueTable, this.jobDataTable);
                this.userName = userName;
            } else {
                this.jobDataTable = new JobDataTableImpl();
            }
        }
        this.jobData = new JobDataImpl(new JobIDValue(), this.job);
        this.jobData.setUserName(this.userName);
        if (this.buttonTable.exists("action:pre")) {
            this.buttonTable.getButton("action:pre").performAction(this);
        }
        if ((pluginList = this.getPluginTable().getPluginList(this.getRapidConfiguration().getStartPage())) != null) {
            for (RapidPlugin plugin : pluginList) {
                plugin.initialise(this);
                plugin.doAction();
            }
        }
    }

    public JobData getJobData() {
        return this.jobData;
    }

    public JobData submit() throws RapidException {
        this.jobData.finalise(this.job);
        this.jobDataTable.addJobData(this.jobData);
        JobPersistence.newJobData(this.jobData);
        JobManager jobManager = this.jobQueueTable.addJobManager(this.jobData);
        jobManager.setPostProcessor(new ActionPostProcessor(this));
        jobManager.runJob();
        this.jobData = new JobDataImpl(new JobIDValue(), this.job);
        this.jobData.setUserName(this.userName);
        this.fileBrowserTable.clear();
        this.fileBrowserTable.update(this.fileSystemTable, this.jobData);
        return this.jobData;
    }

    public void delete(String jobID) throws RapidException {
        JobData data = this.jobDataTable.getJobData(jobID);
        JobPersistence.deleteJobData(data);
        this.jobDataTable.delete(jobID);
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public GlobalVariableTable getGlobalVariableTable() {
        return this.globalVariableTable;
    }

    public PluginTable getPluginTable() {
        return this.pluginTable;
    }

    public JobDataTable getJobDataTable() {
        return this.jobDataTable;
    }

    public ButtonTable getButtonTable() {
        return this.buttonTable;
    }

    public Job getJob() {
        return this.job;
    }

    public JobQueueTable getJobQueueTable() {
        return this.jobQueueTable;
    }

    public FileBrowserTable getFileBrowserTable() {
        return this.fileBrowserTable;
    }

    public FileSystemTable getFileSystemTable() {
        return this.fileSystemTable;
    }

    public RapidConfiguration getRapidConfiguration() {
        return this.rapidConfiguration;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public static void close() {
    }

    public String getPage() throws RapidException {
        if (this.page == null) {
            this.page = this.rapidConfiguration.getStartPage();
        }
        return this.page;
    }

    public void setPage(String page) throws RapidException {
        if (!this.rapidConfiguration.exists(page)) {
            throw new RapidException("No such page " + page);
        }
        this.page = page;
    }

    public void jobIsCompleted(String jobID) throws RapidException {
        Button button = this.getButtonTable().getButton("endJob");
        button.performAction(this);
    }

    public JobData getJobData(String jobID) throws RapidException {
        return jobID == null ? this.jobData : this.jobDataTable.getJobData(jobID);
    }
}

