/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.filesystem.impl;

import java.util.Collection;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.globus.myproxy.MyProxy;
import org.globus.myproxy.MyProxyException;
import org.ietf.jgss.GSSCredential;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobdata.VariableAnalysis;
import uk.ac.nesc.rapid.vfs.gsiftp.GSIFTPFileSystemConfigBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSIFTPFileSystem
extends AbstractFileSystem {
    private String username = "";
    private String password = "";
    private String myProxyURL = "";
    private int myProxyPort = 7512;
    private static final int LIFETIME = 99999;
    private GSSCredential proxyCertificate = null;

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public Collection<String> getVariables() {
        VariableAnalysis analysis = new VariableAnalysis(null);
        analysis.setInput(this.username);
        Collection<String> result = analysis.getVariableNames();
        analysis.setInput(this.password);
        result.addAll(analysis.getVariableNames());
        return result;
    }

    @Override
    public void addVFSOptions(FileSystemOptions opts) throws FileSystemException, MyProxyException, RapidException {
        this.addVFSOptions(opts, null, 0);
    }

    @Override
    public void addVFSOptions(FileSystemOptions opts, JobData table, int subJob) throws FileSystemException, MyProxyException, RapidException {
        if (this.getProxyCertificate() == null && this.getMyProxyURL() != null) {
            MyProxy myproxy = new MyProxy();
            myproxy.setHost(this.getMyProxyURL());
            myproxy.setPort(this.getMyProxyPort());
            this.setProxyCertificate(myproxy.get(this.getResolvedUsername(table, subJob), this.getResolvedPassword(table, subJob), 99999));
        }
        if (this.getProxyCertificate() != null) {
            GSIFTPFileSystemConfigBuilder.getInstance().setGSSCredential(opts, this.getProxyCertificate());
        }
    }

    private String getResolvedPassword(JobData table, int subJob) throws RapidException {
        if (table == null) {
            return this.password;
        }
        VariableAnalysis analysis = new VariableAnalysis(table);
        analysis.setInput(this.password);
        return analysis.getOutput(subJob);
    }

    private String getResolvedUsername(JobData table, int subJob) throws RapidException {
        if (table == null) {
            return this.username;
        }
        VariableAnalysis analysis = new VariableAnalysis(table);
        analysis.setInput(this.username);
        return analysis.getOutput(subJob);
    }

    public String getMyProxyURL() throws RapidException {
        return this.myProxyURL;
    }

    public void setMyProxyURL(String myProxyURL) {
        this.myProxyURL = myProxyURL;
    }

    public int getMyProxyPort() throws RapidException {
        return this.myProxyPort;
    }

    public void setMyProxyPort(int myProxyPort) {
        this.myProxyPort = myProxyPort;
    }

    public void setMyProxyPort(String myProxyPort) {
        this.myProxyPort = Integer.parseInt(myProxyPort);
    }

    public GSSCredential getProxyCertificate() {
        return this.proxyCertificate;
    }

    public void setProxyCertificate(GSSCredential proxyCertificate) {
        this.proxyCertificate = proxyCertificate;
    }

    public String toString() {
        String result = "";
        result = result + "GSIFTP SERVER\n";
        result = result + "description " + this.getName() + "\n";
        result = result + "URL: " + this.getURL() + "\n";
        try {
            result = result + "myproxyhost: " + this.getMyProxyURL() + "\n";
            result = result + "myproxyport: " + this.getMyProxyPort() + "\n";
            result = result + "username: " + this.getUsername() + "\n";
            result = result + "password: " + this.getPassword() + "\n";
        }
        catch (RapidException ex) {
            result = result + "Invalid authentication parameters: " + ex.getMessage();
        }
        return result;
    }
}

