/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.filesystem.impl;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Hashtable;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticator;
import org.apache.commons.vfs.auth.StaticUserAuthenticator;
import org.apache.commons.vfs.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs.provider.sftp.SftpFileSystemConfigBuilder;
import org.globus.myproxy.MyProxyException;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobdata.VariableAnalysis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTPFileSystem
extends AbstractFileSystem {
    private String username = "";
    private String password = "";

    private String getResolvedPassword(JobData jobData, int subJob) throws RapidException {
        if (jobData == null) {
            return this.password;
        }
        VariableAnalysis analysis = new VariableAnalysis(jobData);
        analysis.setInput(this.password);
        return analysis.getOutput(subJob);
    }

    private String getResolvedUsername(JobData jobData, int subJob) throws RapidException {
        if (jobData == null) {
            return this.username;
        }
        VariableAnalysis analysis = new VariableAnalysis(jobData);
        analysis.setInput(this.username);
        return analysis.getOutput(subJob);
    }

    @Override
    public String getAuthURL() throws RapidException {
        int index = this.getURL().indexOf("://") + 3;
        String result = this.getURL().substring(0, index);
        result = result + this.username + ":" + this.password + "@";
        result = result + this.getURL().substring(index);
        return result;
    }

    public String getAuthURL(JobData table, int subJob) throws RapidException {
        int index = this.getURL().indexOf("://") + 3;
        String result = this.getURL().substring(0, index);
        result = result + this.getResolvedUsername(table, subJob) + ":";
        result = result + this.getResolvedPassword(table, subJob) + "@";
        result = result + this.getURL().substring(index);
        return result;
    }

    @Override
    public void addVFSOptions(FileSystemOptions opts) throws FileSystemException, MyProxyException, RapidException {
        this.addVFSOptions(opts, null, 0);
    }

    @Override
    public void addVFSOptions(FileSystemOptions opts, JobData table, int subJob) throws FileSystemException, MyProxyException, RapidException {
        StaticUserAuthenticator staticAuthenticator = new StaticUserAuthenticator(null, this.getResolvedUsername(table, subJob), this.getResolvedPassword(table, subJob));
        DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(opts, (UserAuthenticator)staticAuthenticator);
        SftpFileSystemConfigBuilder.getInstance().setStrictHostKeyChecking(opts, "no");
        SftpFileSystemConfigBuilder.getInstance().setTimeout(opts, Integer.valueOf(3000));
        FtpFileSystemConfigBuilder.getInstance().setDataTimeout(opts, Integer.valueOf(3000));
    }

    private static String readInputStream(InputStream in, Channel channel) throws IOException {
        boolean done = false;
        StringBuffer result = new StringBuffer();
        byte[] tmp = new byte[1024];
        while (!done) {
            int i;
            while (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                result.append(new String(tmp, 0, i));
            }
            if (channel.isClosed()) {
                done = true;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ee) {}
        }
        return result.toString();
    }

    @Override
    public String execute(String command) throws RapidException {
        return this.execute(command, null, 0);
    }

    @Override
    public String execute(String command, JobData jobTable, int subJob) throws RapidException {
        InputStream in = null;
        InputStream err = null;
        try {
            JSch jsch = new JSch();
            String hostname = new URI(this.getURL()).getHost();
            Session session = jsch.getSession(this.getResolvedUsername(jobTable, subJob), hostname, 22);
            session.setPassword(this.getResolvedPassword(jobTable, subJob));
            Hashtable<String, String> config = new Hashtable<String, String>();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.connect();
            ChannelExec channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand("" + command + "");
            in = channel.getInputStream();
            if (in == null) {
                throw new RapidException("Could not get input stream. Maybe hostname " + hostname + " does not exist");
            }
            err = channel.getExtInputStream();
            channel.connect();
            String result = FTPFileSystem.readInputStream(in, (Channel)channel);
            if (channel.getExitStatus() != 0) {
                String error = FTPFileSystem.readInputStream(err, (Channel)channel);
                channel.disconnect();
                session.disconnect();
                throw new RapidException("Executing command " + command + " on host " + this.getURL() + " failed.\nExit code " + channel.getExitStatus() + ". \nError: '" + error + "'");
            }
            channel.disconnect();
            session.disconnect();
            String string = result;
            return string;
        }
        catch (IOException ex) {
            throw new RapidException("IO Error while executing command " + command + " on host " + this.getURL() + ". Cause: " + ex.getMessage());
        }
        catch (JSchException ex) {
            throw new RapidException("SSH Error while executing command " + command + " on host " + this.getURL() + ". Cause: " + ex.getMessage());
        }
        catch (Exception ex) {
            throw new RapidException("Other error " + ex.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public Collection<String> getVariables() {
        VariableAnalysis analysis = new VariableAnalysis(null);
        analysis.setInput(this.username);
        Collection<String> result = analysis.getVariableNames();
        analysis.setInput(this.password);
        result.addAll(analysis.getVariableNames());
        return result;
    }

    public String toString() {
        String result = "";
        result = result + "FTP SERVER\n";
        result = result + "description " + this.getName() + "\n";
        result = result + "URL: " + this.getURL() + "\n";
        result = result + "username: " + this.getUsername() + "\n";
        result = result + "password: " + this.getPassword() + "\n";
        return result;
    }
}

