/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.filesystem;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;
import org.apache.commons.vfs.provider.FileProvider;
import org.apache.commons.vfs.provider.http.HttpFileProvider;
import org.apache.commons.vfs.provider.local.DefaultLocalFileProvider;
import org.globus.myproxy.MyProxyException;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.vfs.ftp.FtpFileProvider;
import uk.ac.nesc.rapid.vfs.gsiftp.GSIFTPFileProvider;
import uk.ac.nesc.rapid.vfs.sftp.SftpFileProvider;

public class FileSystemConnector {
    private DefaultFileSystemManager fsManager = new DefaultFileSystemManager();

    public FileSystemConnector() throws FileSystemException {
        this.fsManager.addProvider("ftp", (FileProvider)new FtpFileProvider());
        this.fsManager.addProvider("sftp", (FileProvider)new SftpFileProvider());
        this.fsManager.addProvider("http", (FileProvider)new HttpFileProvider());
        this.fsManager.addProvider("gsiftp", (FileProvider)new GSIFTPFileProvider());
        this.fsManager.addProvider("file", (FileProvider)new DefaultLocalFileProvider());
        this.fsManager.init();
    }

    public FileObject connect(AbstractFileSystem fileSystem) throws FileSystemException, MyProxyException, RapidException {
        FileSystemOptions options = new FileSystemOptions();
        fileSystem.addVFSOptions(options);
        return this.fsManager.resolveFile(fileSystem.getURL(), options);
    }

    public FileObject connect(AbstractFileSystem fileSystem, JobData table, int subJob) throws FileSystemException, MyProxyException, RapidException {
        FileSystemOptions options = new FileSystemOptions();
        if (table == null) {
            fileSystem.addVFSOptions(options);
        } else {
            fileSystem.addVFSOptions(options, table, subJob);
        }
        return this.fsManager.resolveFile(fileSystem.getURL(), options);
    }

    public void close() {
        this.fsManager.close();
    }

    public void close(FileObject object) {
        if (object.getFileSystem() != null) {
            this.fsManager.closeFileSystem(object.getFileSystem());
        }
    }
}

