/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.button;

import java.io.OutputStream;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import uk.ac.nesc.rapid.button.FileAction;
import uk.ac.nesc.rapid.data.RapidData;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobdata.VariableAnalysis;
import uk.ac.nesc.rapid.value.Value;

public class SaveFileAction
extends FileAction {
    private String variable;

    public void performAction(RapidData rapidData) throws RapidException {
        this.performAction(rapidData, rapidData.getJobData(), 0);
    }

    public void performAction(RapidData rapidData, String jobID, int subJobIndex) throws RapidException {
        this.performAction(rapidData, rapidData.getJobDataTable().getJobData(jobID), subJobIndex);
    }

    private void performAction(RapidData rapidData, JobData jobData, int subJobIndex) throws RapidException {
        try {
            VariableAnalysis analysis = new VariableAnalysis(jobData);
            analysis.setInput(this.getFileSystem());
            String fileSystemName = analysis.getOutput(subJobIndex);
            analysis.setInput(this.getPath());
            String path = analysis.getOutput(subJobIndex);
            AbstractFileSystem fileSystem = rapidData.getFileSystemTable().getFileSystem(fileSystemName);
            FileObject file = rapidData.getFileSystemTable().getFileSystemConnector().connect(fileSystem, rapidData.getJobData(), subJobIndex);
            file = file.resolveFile(path);
            if (!file.exists()) {
                file.createFile();
            }
            FileContent content = file.getContent();
            OutputStream stream = content.getOutputStream();
            Value value = jobData.getVariable(this.getVariable());
            String data = value.get();
            stream.write(data.getBytes());
            stream.close();
            content.close();
            file.close();
        }
        catch (Exception ex) {
            throw new RapidException("Error saving variable to file " + ex.getMessage());
        }
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }
}

