/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.button;

import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import uk.ac.nesc.rapid.button.FileAction;
import uk.ac.nesc.rapid.data.RapidData;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobdata.VariableAnalysis;

public class DeleteFileAction
extends FileAction {
    public void performAction(RapidData rapidData, String jobID, int subJobIndex) throws RapidException {
        this.performAction(rapidData, rapidData.getJobDataTable().getJobData(jobID), subJobIndex);
    }

    public void performAction(RapidData rapidData) throws RapidException {
        this.performAction(rapidData, rapidData.getJobData(), 0);
    }

    private void performAction(RapidData rapidData, JobData jobData, int subJobIndex) throws RapidException {
        try {
            VariableAnalysis analysis = new VariableAnalysis(jobData);
            analysis.setInput(this.getFileSystem());
            String fileSystemName = analysis.getOutput(subJobIndex);
            analysis.setInput(this.getPath());
            String path = analysis.getOutput(subJobIndex);
            AbstractFileSystem fileSystem = rapidData.getFileSystemTable().getFileSystem(fileSystemName);
            FileObject file = rapidData.getFileSystemTable().getFileSystemConnector().connect(fileSystem, jobData, subJobIndex);
            file = file.resolveFile(path);
            if (file.exists()) {
                file.delete((FileSelector)new AllFileSelector());
            }
            file.close();
        }
        catch (Exception ex) {
            throw new RapidException("Error deleting files: " + ex.getMessage());
        }
    }
}

