/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.button;

import java.util.List;
import java.util.Vector;
import uk.ac.nesc.rapid.button.Action;
import uk.ac.nesc.rapid.data.RapidData;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobdata.VariableAnalysis;
import uk.ac.nesc.rapid.value.impl.SingleValue;

public class CallProgramAction
implements Action {
    private String fileSystemName = "";
    private String path = "";
    private String variable = "";
    private List<String> argumentList = new Vector<String>();

    public void addArgument(String argument) {
        this.argumentList.add(argument);
    }

    public String getFileSystem() {
        return this.fileSystemName;
    }

    public void setFileSystem(String fileSystem) {
        this.fileSystemName = fileSystem;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public String getVariable() {
        return this.variable;
    }

    private void performAction(RapidData rapidData, JobData jobData, int jobIndex) throws RapidException {
        VariableAnalysis analysis = new VariableAnalysis(jobData);
        analysis.setInput(this.fileSystemName);
        AbstractFileSystem fileSystem = rapidData.getFileSystemTable().getFileSystem(analysis.getOutput(jobIndex));
        analysis.setInput(this.path);
        StringBuffer command = new StringBuffer(analysis.getOutput(jobIndex));
        for (String arg : this.argumentList) {
            analysis.setInput(arg);
            command.append(" " + analysis.getOutput(jobIndex));
        }
        String result = fileSystem.execute(command.toString(), jobData, jobIndex);
        jobData.setVariable(this.variable, new SingleValue(result));
    }

    public void performAction(RapidData rapidData, String jobID, int subJobIndex) throws RapidException {
        this.performAction(rapidData, rapidData.getJobDataTable().getJobData(jobID), subJobIndex);
    }

    public void performAction(RapidData rapidData) throws RapidException {
        this.performAction(rapidData, rapidData.getJobData(), 0);
    }
}

