/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.button;

import java.util.List;
import java.util.Vector;
import uk.ac.nesc.rapid.button.Action;
import uk.ac.nesc.rapid.data.RapidData;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.value.impl.JobIDValue;

public class Button {
    private String name = null;
    private String selection = null;
    List<Action> actionList = new Vector<Action>();

    public void setSelection(String selection) {
        this.selection = selection;
    }

    public String getSelection() {
        return this.selection;
    }

    public void addAction(Action action) {
        this.actionList.add(action);
    }

    public void performAction(RapidData rapidData, String jobID) throws RapidException {
        for (Action action : this.actionList) {
            action.performAction(rapidData, jobID, JobIDValue.getSubJobIndex(jobID));
        }
    }

    public void performAction(RapidData rapidData) throws RapidException {
        if (this.getSelection() == null) {
            for (Action action : this.actionList) {
                action.performAction(rapidData);
            }
        } else {
            String jobID = rapidData.getGlobalVariableTable().getGlobalVariable(this.getSelection()).get();
            this.performAction(rapidData, jobID);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "Name: " + this.name;
    }
}

