/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.xml;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import uk.ac.nesc.rapid.xml.RapidXML;

public class RapidTransform {
    public static void transform() throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        URL xmlURL = RapidXML.getXMLFile();
        URL xslURL = RapidXML.getXSLFile();
        RapidTransform.transform(xmlURL, xslURL);
    }

    public static void transform(URL xmlURL, URL xslURL) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        String xmlSymbolFileName = xmlURL.toString();
        int index = xmlSymbolFileName.lastIndexOf("/");
        if (index > 0) {
            xmlSymbolFileName = xmlSymbolFileName.substring(0, index) + "/" + "rapid-symbol.xml";
        }
        RapidTransform.transform(xmlURL, xslURL, new URL(xmlSymbolFileName));
    }

    public static void transform(URL xmlURL, URL xslURL, URL resultURL) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(new StreamSource(xslURL.getFile()));
        transformer.transform(new StreamSource(xmlURL.getFile()), new StreamResult(new FileOutputStream(resultURL.getPath())));
    }
}

