/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.value.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobdata.VariableAnalysis;
import uk.ac.nesc.rapid.jsp.ValuePrinter;
import uk.ac.nesc.rapid.value.Value;
import uk.ac.nesc.rapid.value.impl.BaseValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@DiscriminatorValue(value="SINGLEVALUE")
@Table(name="SINGLEVALUE")
public class SingleValue
extends BaseValue
implements PersistenceCapable {
    private String value = null;
    @Column(name="MINVALUE")
    private Double min = null;
    @Column(name="MAXVALUE")
    private Double max = null;
    @Column(name="REGULAREXP")
    private String regExp = null;
    @Transient
    private String inFile = null;
    @Transient
    private String outFile = null;
    private static int pcInheritedFieldCount = BaseValue.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Luk$ac$nesc$rapid$value$impl$BaseValue;
    static /* synthetic */ Class class$Ljava$lang$Double;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Luk$ac$nesc$rapid$value$impl$SingleValue;

    public SingleValue(String value) {
        this.put(value);
    }

    public SingleValue() {
        this.value = "";
    }

    @Override
    public String get() {
        return SingleValue.pcGetvalue(this);
    }

    @Override
    public String get(int index) {
        return SingleValue.pcGetvalue(this);
    }

    @Override
    public void put(int index, String value) {
        this.put(value);
    }

    @Override
    public void put(String value) {
        if (value == null) {
            SingleValue.pcSetvalue(this, "");
        } else {
            SingleValue.pcSetvalue(this, value);
        }
    }

    @Override
    public void put(String[] values) {
        if (values == null) {
            SingleValue.pcSetvalue(this, "");
        } else if (values.length > 0) {
            SingleValue.pcSetvalue(this, values[0]);
        } else {
            SingleValue.pcSetvalue(this, "");
        }
    }

    @Override
    public void put(List<String> values) {
        if (values == null) {
            SingleValue.pcSetvalue(this, "");
        } else if (values.size() > 0) {
            SingleValue.pcSetvalue(this, values.get(0));
        } else {
            SingleValue.pcSetvalue(this, "");
        }
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public String print(ValuePrinter printer) throws RapidException {
        return printer.print(this);
    }

    @Override
    public Value copy() {
        SingleValue copy = new SingleValue(SingleValue.pcGetvalue(this));
        copy.setMax(SingleValue.pcGetmax(this));
        copy.setMin(SingleValue.pcGetmin(this));
        copy.setRegExp(SingleValue.pcGetregExp(this));
        copy.setErrorMessage(this.getErrorMessage());
        return copy;
    }

    @Override
    public boolean validate() {
        if (SingleValue.pcGetvalue(this) == null) {
            return true;
        }
        if (this.getRegExp() != null) {
            try {
                if (!SingleValue.pcGetvalue(this).matches(SingleValue.pcGetregExp(this))) {
                    return false;
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return false;
            }
        }
        if (this.getMin() != null || this.getMax() != null) {
            double doubleValue;
            try {
                doubleValue = Double.parseDouble(SingleValue.pcGetvalue(this));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            boolean result = true;
            result &= this.getMax() == null ? true : this.getMax() >= doubleValue;
            return result &= this.getMin() == null ? true : this.getMin() <= doubleValue;
        }
        return true;
    }

    public void setMin(double min) {
        SingleValue.pcSetmin(this, min);
    }

    public void setMax(double max) {
        SingleValue.pcSetmax(this, max);
    }

    public void setMin(Double min) {
        SingleValue.pcSetmin(this, min);
    }

    public void setMax(Double max) {
        SingleValue.pcSetmax(this, max);
    }

    public void setRegExp(String regExp) {
        SingleValue.pcSetregExp(this, regExp);
    }

    public Double getMin() {
        return SingleValue.pcGetmin(this);
    }

    public Double getMax() {
        return SingleValue.pcGetmax(this);
    }

    public String getRegExp() {
        return SingleValue.pcGetregExp(this);
    }

    public String getInFile() {
        return this.inFile;
    }

    public void setInFile(String inFile) {
        this.inFile = inFile;
        File file = new File(inFile);
        try {
            FileReader reader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(reader);
            StringBuffer buffer = new StringBuffer();
            String line = bufferedReader.readLine();
            while (line != null) {
                buffer.append(line + "\n");
                line = bufferedReader.readLine();
            }
            SingleValue.pcSetvalue(this, buffer.substring(0, buffer.length() - 1));
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getOutFile() {
        return this.outFile;
    }

    public void setOutFile(String outFile) {
        this.outFile = outFile;
    }

    public Value resolve(JobData table) throws RapidException {
        VariableAnalysis analysis = new VariableAnalysis(table);
        analysis.setInput(SingleValue.pcGetvalue(this));
        return new SingleValue(analysis.getOutput(0));
    }

    @Override
    public String resolve(JobData table, int subJob) throws RapidException {
        VariableAnalysis analysis = new VariableAnalysis(table);
        analysis.setInput(SingleValue.pcGetvalue(this));
        return analysis.getOutput(0);
    }

    @Override
    public int resolveSize(JobData data) throws RapidException {
        return 1;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 53 * super.hashCode();
        hash = 29 * hash + (SingleValue.pcGetvalue(this) != null ? SingleValue.pcGetvalue(this).hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleValue other = (SingleValue)obj;
        if (!super.equals(other)) {
            return false;
        }
        if (!(SingleValue.pcGetvalue(this) == SingleValue.pcGetvalue(other) || SingleValue.pcGetvalue(this) != null && SingleValue.pcGetvalue(this).equals(SingleValue.pcGetvalue(other)))) {
            return false;
        }
        if (!(SingleValue.pcGetmin(this) == SingleValue.pcGetmin(other) || SingleValue.pcGetmin(this) != null && SingleValue.pcGetmin(this).equals(SingleValue.pcGetmin(other)))) {
            return false;
        }
        if (!(SingleValue.pcGetmax(this) == SingleValue.pcGetmax(other) || SingleValue.pcGetmax(this) != null && SingleValue.pcGetmax(this).equals(SingleValue.pcGetmax(other)))) {
            return false;
        }
        return SingleValue.pcGetregExp(this) == SingleValue.pcGetregExp(other) || SingleValue.pcGetregExp(this) != null && SingleValue.pcGetregExp(this).equals(SingleValue.pcGetregExp(other));
    }

    public String toString() {
        String result = "";
        result = result + "SingleValue\n";
        result = result + "regexp: " + this.getRegExp() + "\n";
        result = result + "error message: " + this.getErrorMessage() + "\n";
        result = result + "min " + this.getMin() + "\n";
        result = result + "max " + this.getMax() + "\n";
        result = result + "Contents: " + this.get() + "\n";
        return result;
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        Class clazz = class$Luk$ac$nesc$rapid$value$impl$BaseValue != null ? class$Luk$ac$nesc$rapid$value$impl$BaseValue : (class$Luk$ac$nesc$rapid$value$impl$BaseValue = SingleValue.class$("uk.ac.nesc.rapid.value.impl.BaseValue"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"max", "min", "regExp", "value"};
        Class[] classArray = new Class[4];
        Class clazz2 = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = SingleValue.class$("java.lang.Double"));
        classArray[0] = clazz2;
        classArray[1] = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = SingleValue.class$("java.lang.Double"));
        Class clazz3 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SingleValue.class$("java.lang.String"));
        classArray[2] = clazz3;
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SingleValue.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26};
        Class clazz4 = class$Luk$ac$nesc$rapid$value$impl$SingleValue != null ? class$Luk$ac$nesc$rapid$value$impl$SingleValue : (class$Luk$ac$nesc$rapid$value$impl$SingleValue = SingleValue.class$("uk.ac.nesc.rapid.value.impl.SingleValue"));
        PCRegistry.register((Class)clazz4, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"SingleValue", (PersistenceCapable)new SingleValue());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.max = null;
        this.min = null;
        this.regExp = null;
        this.value = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        SingleValue singleValue = new SingleValue();
        if (bl) {
            singleValue.pcClearFields();
        }
        singleValue.pcStateManager = stateManager;
        singleValue.pcCopyKeyFieldsFromObjectId(object);
        return singleValue;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        SingleValue singleValue = new SingleValue();
        if (bl) {
            singleValue.pcClearFields();
        }
        singleValue.pcStateManager = stateManager;
        return singleValue;
    }

    protected static int pcGetManagedFieldCount() {
        return 4 + BaseValue.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.max = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.min = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.regExp = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.value = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.max);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.min);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.regExp);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.value);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(SingleValue singleValue, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(singleValue, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.max = singleValue.max;
                return;
            }
            case 1: {
                this.min = singleValue.min;
                return;
            }
            case 2: {
                this.regExp = singleValue.regExp;
                return;
            }
            case 3: {
                this.value = singleValue.value;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        SingleValue singleValue = (SingleValue)object;
        if (singleValue.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(singleValue, nArray[n]);
            ++n;
        }
    }

    private static final Double pcGetmax(SingleValue singleValue) {
        if (singleValue.pcStateManager == null) {
            return singleValue.max;
        }
        int n = pcInheritedFieldCount + 0;
        singleValue.pcStateManager.accessingField(n);
        return singleValue.max;
    }

    private static final void pcSetmax(SingleValue singleValue, Double d) {
        if (singleValue.pcStateManager == null) {
            singleValue.max = d;
            return;
        }
        singleValue.pcStateManager.settingObjectField((PersistenceCapable)singleValue, pcInheritedFieldCount + 0, (Object)singleValue.max, (Object)d, 0);
    }

    private static final Double pcGetmin(SingleValue singleValue) {
        if (singleValue.pcStateManager == null) {
            return singleValue.min;
        }
        int n = pcInheritedFieldCount + 1;
        singleValue.pcStateManager.accessingField(n);
        return singleValue.min;
    }

    private static final void pcSetmin(SingleValue singleValue, Double d) {
        if (singleValue.pcStateManager == null) {
            singleValue.min = d;
            return;
        }
        singleValue.pcStateManager.settingObjectField((PersistenceCapable)singleValue, pcInheritedFieldCount + 1, (Object)singleValue.min, (Object)d, 0);
    }

    private static final String pcGetregExp(SingleValue singleValue) {
        if (singleValue.pcStateManager == null) {
            return singleValue.regExp;
        }
        int n = pcInheritedFieldCount + 2;
        singleValue.pcStateManager.accessingField(n);
        return singleValue.regExp;
    }

    private static final void pcSetregExp(SingleValue singleValue, String string) {
        if (singleValue.pcStateManager == null) {
            singleValue.regExp = string;
            return;
        }
        singleValue.pcStateManager.settingStringField((PersistenceCapable)singleValue, pcInheritedFieldCount + 2, singleValue.regExp, string, 0);
    }

    private static final String pcGetvalue(SingleValue singleValue) {
        if (singleValue.pcStateManager == null) {
            return singleValue.value;
        }
        int n = pcInheritedFieldCount + 3;
        singleValue.pcStateManager.accessingField(n);
        return singleValue.value;
    }

    private static final void pcSetvalue(SingleValue singleValue, String string) {
        if (singleValue.pcStateManager == null) {
            singleValue.value = string;
            return;
        }
        singleValue.pcStateManager.settingStringField((PersistenceCapable)singleValue, pcInheritedFieldCount + 3, singleValue.value, string, 0);
    }
}

