/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.symbol.impl;

import java.io.File;
import org.apache.commons.fileupload.FileItem;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobdata.VariableAnalysis;
import uk.ac.nesc.rapid.symbol.impl.SymbolImpl;
import uk.ac.nesc.rapid.value.Value;
import uk.ac.nesc.rapid.value.impl.SingleValue;

public class FileUploadSymbol
extends SymbolImpl {
    private String destination = "";

    public FileUploadSymbol() {
        this.setReadOnly(true);
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public Value get(JobData table) throws RapidException {
        return new SingleValue("fileupload");
    }

    public void put(JobData table, FileItem item) throws RapidException {
        if (item.isFormField()) {
            throw new RapidException("Item " + item.getFieldName() + " is not a File at symbol " + this.getVariableName());
        }
        if (!"".equals(item.getName())) {
            VariableAnalysis analysis = new VariableAnalysis(table);
            analysis.setInput(this.destination);
            File uploadedFile = new File(analysis.getOutput(0));
            try {
                item.write(uploadedFile);
            }
            catch (Exception ex) {
                throw new RapidException("Unable to write file to " + this.destination + " : " + ex.getMessage());
            }
        }
    }

    public String toString() {
        return "\nFILE UPLOAD\nDestination \n" + this.destination + "\n" + super.toString();
    }
}

