/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.jobmanager.bes;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.globus.myproxy.MyProxyException;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.data.filesystem.FileSystemConnector;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.job.EnvironmentVariable;
import uk.ac.nesc.rapid.job.Job;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.BESState;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.ForkProperties;
import uk.ac.nesc.rapid.value.Value;

public class ForkThread
implements Runnable {
    private Job job;
    private int subJob;
    private ForkProperties properties;
    private AbstractFileSystem fileSystem = null;
    private FileObject submitFileObject = null;
    private JobData jobData = null;

    public ForkThread(JobData data, Job job, int subJob, AbstractFileSystem fileSystem, ForkProperties properties) {
        this.job = job;
        this.subJob = subJob;
        this.fileSystem = fileSystem;
        this.properties = properties;
        this.jobData = data;
    }

    public void run() {
        BESState state = (BESState)this.jobData.getState();
        try {
            state.setPluginState(this.subJob, 1);
            this.submitFileObject = FileSystemConnector.getInstance().connect(this.fileSystem, this.jobData, this.subJob);
            Value workingDirValue = this.job.getWorkingDir();
            if (workingDirValue.size() != 0 && workingDirValue.size() > 0) {
                this.submitFileObject = this.submitFileObject.resolveFile(workingDirValue.resolve(this.jobData, this.subJob));
            }
            String subJobID = this.jobData.getJobID().getSubJobID(this.subJob);
            this.submitFileObject = this.submitFileObject.resolveFile(this.properties.getSubmitFileName() + subJobID + ".sh");
            this.submitFileObject.createFile();
            FileContent submitFileContent = this.submitFileObject.getContent();
            OutputStream is = submitFileContent.getOutputStream();
            is.write(this.generateSubmitFile().getBytes());
            is.close();
            state.setPluginState(this.subJob, 3);
            this.fileSystem.execute("source " + this.submitFileObject.getName().getPath(), this.jobData, this.subJob);
            state.setPluginState(this.subJob, 4);
        }
        catch (IOException ex) {
            state.setPluginState(this.subJob, 5, "Error connecting to filesystem " + this.fileSystem.getName() + " : cause " + ex.getMessage());
        }
        catch (MyProxyException ex) {
            state.setPluginState(this.subJob, 5, "MYPROXY LOOKUPS IN FORK SHOULD NOT HAPPEN");
        }
        catch (RapidException ex) {
            state.setPluginState(this.subJob, 5, "Error! cause: " + ex.getMessage());
        }
    }

    private String generateSubmitFile() throws RapidException {
        Value stdinValue;
        Value stdoutValue;
        Value stderrValue;
        String result = "";
        result = result + "#!/bin/sh\n";
        String workingDir = this.job.getWorkingDir().resolve(this.jobData, this.subJob);
        if (workingDir != null) {
            result = result + "cd " + workingDir + "\n";
        }
        result = result + "export PATH=$PATH:.\n";
        Collection<EnvironmentVariable> envCollection = this.job.getEnvironmentVariableCollection();
        for (EnvironmentVariable env : envCollection) {
            result = result + "export " + env.getName().resolve(this.jobData, this.subJob) + "=" + env.getValue().resolve(this.jobData, this.subJob) + "\n";
        }
        result = result + "chmod u+x " + this.job.getExecutable().resolve(this.jobData, this.subJob) + " 2> /dev/null\n";
        result = result + this.job.getExecutable().resolve(this.jobData, this.subJob);
        if (this.job.getParameterList().size() > 0) {
            result = result + " ";
            for (Value arg : this.job.getParameterList()) {
                result = result + arg.resolve(this.jobData, this.subJob) + " ";
            }
        }
        if ((stderrValue = this.job.getStderr()).size() > 0) {
            result = result + " 2> " + stderrValue.resolve(this.jobData, this.subJob) + " ";
        }
        if ((stdoutValue = this.job.getStdout()).size() > 0) {
            result = result + " 1> " + stdoutValue.resolve(this.jobData, this.subJob) + " ";
        }
        if ((stdinValue = this.job.getStdin()).size() > 0) {
            result = result + " < " + stdinValue.resolve(this.jobData, this.subJob) + " ";
        }
        result = result + "\n";
        return result;
    }

    public void doCleanUp() throws RapidException {
        if (this.submitFileObject != null) {
            try {
                if (this.submitFileObject.exists()) {
                    this.submitFileObject.delete();
                }
            }
            catch (FileSystemException ex) {
                throw new RapidException("Error deleting submission file in Fork Plugin : " + ex.getMessage());
            }
        }
    }
}

