/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.impl;

import java.util.HashMap;
import java.util.Map;
import uk.ac.nesc.rapid.data.filesystem.FileSystemTable;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.job.Job;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobsubmission.JobQueue;
import uk.ac.nesc.rapid.jobsubmission.JobQueueTable;
import uk.ac.nesc.rapid.jobsubmission.impl.JobQueueImpl;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.JobManager;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.JobManagerFactory;

public class JobQueueTableImpl
implements JobQueueTable {
    private Map<String, JobQueue> jobQueueTable = new HashMap<String, JobQueue>();
    private Job job;
    private FileSystemTable fileSystemTable;

    public JobQueueTableImpl(Job job, FileSystemTable fileSystemTable) {
        this.job = job;
        this.fileSystemTable = fileSystemTable;
    }

    public JobQueue getJobQueue(String name) {
        return this.jobQueueTable.get(name);
    }

    public int size() {
        return this.jobQueueTable.size();
    }

    public void addJobQueue(String name, JobManagerFactory factory) throws RapidException {
        JobQueueImpl queue = new JobQueueImpl(this.job, this.fileSystemTable, factory);
        this.jobQueueTable.put(name, queue);
    }

    private JobQueue getJobQueue(JobData table) throws RapidException {
        String server = this.job.getSubmissionServer().resolve(table, 0);
        JobQueue queue = this.getJobQueue(server);
        if (queue == null) {
            throw new RapidException("Could not find a server with name " + server);
        }
        return queue;
    }

    public JobManager addJobManager(JobData data) throws RapidException {
        return this.getJobQueue(data).addJob(data);
    }

    public JobManager getJobManager(JobData data) throws RapidException {
        return this.getJobQueue(data).getJob(data);
    }
}

