/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.job.impl;

import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.job.DataStage;
import uk.ac.nesc.rapid.job.DataStageURL;
import uk.ac.nesc.rapid.job.StageType;
import uk.ac.nesc.rapid.value.Value;
import uk.ac.nesc.rapid.value.impl.EmptyValue;

public class DataStageImpl
implements DataStage {
    private DataStageURL targetURL = null;
    private DataStageURL sourceURL = null;
    private Value fileName = new EmptyValue();
    private boolean deleteOnTermination = false;
    private Value creationFlag = new EmptyValue();

    public DataStageURL getURL(StageType type) throws RapidException {
        if (type == StageType.SOURCE) {
            return this.getSourceURL();
        }
        return this.getTargetURL();
    }

    public void setURL(DataStageURL url, StageType type) {
        if (type == StageType.SOURCE) {
            this.setSourceURL(url);
        } else {
            this.setTargetURL(url);
        }
    }

    public DataStageURL getTargetURL() throws RapidException {
        if (this.targetURL == null) {
            throw new RapidException("No TARGET URL");
        }
        return this.targetURL;
    }

    public void setTargetURL(DataStageURL targetURL) {
        this.targetURL = targetURL;
    }

    public DataStageURL getSourceURL() throws RapidException {
        if (this.sourceURL == null) {
            throw new RapidException("No SOURCE URL");
        }
        return this.sourceURL;
    }

    public void setSourceURL(DataStageURL sourceURL) {
        this.sourceURL = sourceURL;
    }

    public Value getFileName() throws RapidException {
        return this.fileName;
    }

    public void setFileName(Value fileName) {
        this.fileName = fileName;
    }

    public boolean isDeleteOnTermination() {
        return this.deleteOnTermination;
    }

    public void setDeleteOnTermination(boolean deleteOnTermination) {
        this.deleteOnTermination = deleteOnTermination;
    }

    public void setDeleteOnTermination(Value deleteOnTermination) {
        this.deleteOnTermination = deleteOnTermination == null || deleteOnTermination.get() == null || deleteOnTermination.get().toLowerCase().equals("true");
    }

    public void setCreationFlag(Value flag) {
        this.creationFlag = flag;
    }

    public Value getCreationFlag() {
        return this.creationFlag;
    }

    public String toString() {
        String result = "";
        result = result + "Target: \n" + this.targetURL + "\n";
        result = result + "Source: \n" + this.sourceURL + "\n";
        result = result + "Filename: " + this.fileName + "\n";
        result = result + "Creation Flag: " + this.creationFlag + "\n";
        result = result + "DeleteOnTermination " + this.deleteOnTermination + "\n";
        return result;
    }

    public boolean existsURL(StageType type) {
        if (type == StageType.SOURCE) {
            return this.sourceURL != null;
        }
        return this.targetURL != null;
    }

    public boolean existsSourceURL() {
        return this.sourceURL != null;
    }

    public boolean existsTargetURL() {
        return this.targetURL != null;
    }

    public int hashCode() {
        int hash = 5;
        hash = 13 * hash + (this.targetURL != null ? this.targetURL.hashCode() : 0);
        hash = 13 * hash + (this.sourceURL != null ? this.sourceURL.hashCode() : 0);
        hash = 13 * hash + (this.fileName != null ? this.fileName.hashCode() : 0);
        hash = 13 * hash + (this.deleteOnTermination ? 1 : 0);
        hash = 13 * hash + (this.creationFlag != null ? this.creationFlag.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataStageImpl other = (DataStageImpl)obj;
        if (!(this.targetURL == other.targetURL || this.targetURL != null && this.targetURL.equals(other.targetURL))) {
            return false;
        }
        if (!(this.sourceURL == other.sourceURL || this.sourceURL != null && this.sourceURL.equals(other.sourceURL))) {
            return false;
        }
        if (!(this.fileName == other.fileName || this.fileName != null && this.fileName.equals(other.fileName))) {
            return false;
        }
        if (this.deleteOnTermination != other.deleteOnTermination) {
            return false;
        }
        return this.creationFlag == other.creationFlag || this.creationFlag != null && this.creationFlag.equals(other.creationFlag);
    }
}

