/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.browser.impl;

import java.util.HashMap;
import java.util.Map;
import uk.ac.nesc.rapid.data.browser.FileBrowser;
import uk.ac.nesc.rapid.data.browser.FileBrowserTable;
import uk.ac.nesc.rapid.data.filesystem.FileSystemTable;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.JobData;

public class FileBrowserTableImpl
implements FileBrowserTable {
    private Map<String, FileBrowser> fileBrowserMap = new HashMap<String, FileBrowser>();

    public void addFileBrowser(FileBrowser browser) throws RapidException {
        this.fileBrowserMap.put(browser.getPathVariableName(), browser);
    }

    public int size() {
        return this.fileBrowserMap.size();
    }

    public void update(FileSystemTable fileSystemTable, JobData table) throws RapidException {
        for (FileBrowser browser : this.fileBrowserMap.values()) {
            try {
                browser.update(fileSystemTable, table);
            }
            catch (Exception ex) {
                throw new RapidException("Error updating browser: " + ex.getMessage());
            }
        }
    }

    public void clear() {
        for (FileBrowser browser : this.fileBrowserMap.values()) {
            browser.clear();
        }
    }

    public FileBrowser getFileBrowser(String name) throws RapidException {
        FileBrowser result = this.fileBrowserMap.get(name);
        if (result == null) {
            throw new RapidException("Could not find file browser for variable " + name);
        }
        return result;
    }
}

