/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data;

import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import uk.ac.nesc.rapid.button.ButtonTable;
import uk.ac.nesc.rapid.data.RapidConfiguration;
import uk.ac.nesc.rapid.data.browser.FileBrowserTable;
import uk.ac.nesc.rapid.data.filesystem.FileSystemTable;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.job.Job;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobdata.JobDataImpl;
import uk.ac.nesc.rapid.jobdata.JobDataTable;
import uk.ac.nesc.rapid.jobdata.JobDataTableImpl;
import uk.ac.nesc.rapid.jobsubmission.JobQueueTable;
import uk.ac.nesc.rapid.persistence.JobPersistence;
import uk.ac.nesc.rapid.symbol.SymbolTable;
import uk.ac.nesc.rapid.value.impl.JobIDValue;
import uk.ac.nesc.rapid.xml.ButtonTableReader;
import uk.ac.nesc.rapid.xml.FileBrowserReader;
import uk.ac.nesc.rapid.xml.FileSystemReader;
import uk.ac.nesc.rapid.xml.JobQueueReader;
import uk.ac.nesc.rapid.xml.JobReader;
import uk.ac.nesc.rapid.xml.PersistenceReader;
import uk.ac.nesc.rapid.xml.RapidConfigurationReader;
import uk.ac.nesc.rapid.xml.SymbolTableReader;

public class RapidData {
    private SymbolTable symbolTable = null;
    private Job job = null;
    private JobDataTable jobDataTable = null;
    private JobData jobData = null;
    private JobQueueTable jobQueueTable = null;
    private FileBrowserTable fileBrowserTable = null;
    private FileSystemTable fileSystemTable = null;
    private ButtonTable buttonTable = null;
    private RapidConfiguration rapidConfiguration = null;
    private String userName = null;
    private String page = null;

    public RapidData(URL xmlFile) throws IOException, SAXException, RapidException, ParserConfigurationException {
        this(xmlFile, null);
    }

    public RapidData(URL xmlFile, String userName) throws IOException, SAXException, RapidException, ParserConfigurationException {
        this.symbolTable = SymbolTableReader.read(xmlFile);
        this.job = JobReader.read(xmlFile);
        this.fileSystemTable = FileSystemReader.read(xmlFile);
        this.jobQueueTable = JobQueueReader.read(xmlFile, this.job, this.fileSystemTable);
        this.rapidConfiguration = RapidConfigurationReader.read(xmlFile);
        this.fileBrowserTable = FileBrowserReader.read(xmlFile);
        this.buttonTable = ButtonTableReader.read(xmlFile);
        if (userName == null) {
            this.jobDataTable = new JobDataTableImpl();
        } else {
            PersistenceReader.read(xmlFile);
            if (JobPersistence.getDbms() != null) {
                JobPersistence.startDatabase();
                this.jobDataTable = JobPersistence.loadJobDataTable(userName);
                JobPersistence.restartJobSubmissions(this.jobQueueTable, this.jobDataTable);
                this.userName = userName;
            } else {
                this.jobDataTable = new JobDataTableImpl();
            }
        }
        this.jobData = new JobDataImpl(new JobIDValue(), this.job);
        this.jobData.setUserName(this.userName);
    }

    public JobData getJobData() {
        return this.jobData;
    }

    public JobData submit() throws RapidException {
        this.jobData.finalise(this.job);
        this.jobDataTable.addJobData(this.jobData);
        JobPersistence.newJobData(this.jobData);
        this.jobQueueTable.addJobManager(this.jobData).runJob();
        this.jobData = new JobDataImpl(new JobIDValue(), this.job);
        this.jobData.setUserName(this.userName);
        this.fileBrowserTable.clear();
        return this.jobData;
    }

    public void delete(String jobID) throws RapidException {
        JobData data = this.jobDataTable.getJobData(jobID);
        JobPersistence.deleteJobData(data);
        this.jobDataTable.delete(jobID);
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public JobDataTable getJobDataTable() {
        return this.jobDataTable;
    }

    public ButtonTable getButtonTable() {
        return this.buttonTable;
    }

    public Job getJob() {
        return this.job;
    }

    public JobQueueTable getJobQueueTable() {
        return this.jobQueueTable;
    }

    public FileBrowserTable getFileBrowserTable() {
        return this.fileBrowserTable;
    }

    public FileSystemTable getFileSystemTable() {
        return this.fileSystemTable;
    }

    public RapidConfiguration getRapidConfiguration() {
        return this.rapidConfiguration;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public static void close() {
    }

    public String getJobID() {
        return this.jobData.getJobID().getJobID();
    }

    public String getPage() throws RapidException {
        if (this.page == null) {
            this.page = this.rapidConfiguration.getStartPage();
        }
        return this.page;
    }

    public void setPage(String page) throws RapidException {
        if (!this.rapidConfiguration.exists(page)) {
            throw new RapidException("No such page " + page);
        }
        this.page = page;
    }
}

