/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.button;

import java.io.OutputStream;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import uk.ac.nesc.rapid.button.FileButton;
import uk.ac.nesc.rapid.data.RapidData;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.data.filesystem.FileSystemConnector;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.VariableAnalysis;
import uk.ac.nesc.rapid.value.Value;

public class SaveFileButton
extends FileButton {
    public void performAction(RapidData rapidData) throws RapidException {
        try {
            VariableAnalysis analysis = new VariableAnalysis(rapidData.getJobData());
            analysis.setInput(this.getFileSystem());
            String fileSystemName = analysis.getOutput(0);
            analysis.setInput(this.getPath());
            String path = analysis.getOutput(0);
            AbstractFileSystem fileSystem = rapidData.getFileSystemTable().getFileSystem(fileSystemName);
            FileObject file = FileSystemConnector.getInstance().connect(fileSystem, rapidData.getJobData(), 0);
            file = file.resolveFile(path);
            if (!file.exists()) {
                file.createFile();
            }
            FileContent content = file.getContent();
            OutputStream stream = content.getOutputStream();
            Value value = rapidData.getJobData().getVariable(this.getVariable());
            String data = value.get();
            stream.write(data.getBytes());
            stream.close();
            content.close();
            file.close();
        }
        catch (Exception ex) {
            throw new RapidException("Error saving variable to file " + ex.getMessage());
        }
    }
}

