/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.xml;

import java.io.IOException;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.jaxp.validation.RELAXNGSchemaFactoryImpl;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RapidSchema {
    static RapidSchema instance = null;
    static Schema schema = null;
    static Validator validator = null;

    private RapidSchema() throws SAXParseException, SAXException, VerifierConfigurationException {
        RELAXNGSchemaFactoryImpl schemaFactory = null;
        schemaFactory = new RELAXNGSchemaFactoryImpl();
        URL schemaURL = RapidSchema.class.getClassLoader().getResource("rapid.rng");
        schemaFactory.setErrorHandler(new SchemaErrorHandler());
        schema = schemaFactory.newSchema(schemaURL);
        validator = schema.newValidator();
        validator.setErrorHandler(new SchemaErrorHandler());
    }

    public static Schema getSchema() throws SAXParseException, SAXException, VerifierConfigurationException {
        if (schema == null || instance == null) {
            instance = new RapidSchema();
        }
        return schema;
    }

    public static void validate(String xmlFile) throws SAXParseException, SAXException, IOException, VerifierConfigurationException {
        if (schema == null || instance == null) {
            RapidSchema.getSchema();
        }
        StreamSource source = new StreamSource(xmlFile);
        validator.validate(source);
    }

    public static class SchemaErrorHandler
    implements ErrorHandler {
        public void error(SAXParseException exception) throws SAXParseException {
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXParseException {
            throw exception;
        }

        public void warning(SAXParseException exception) throws SAXParseException {
            throw exception;
        }
    }
}

