/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.xml;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.job.DataStage;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.data.job.StageType;
import uk.ac.nesc.rapid.data.job.impl.DataStageImpl;
import uk.ac.nesc.rapid.data.job.impl.DataStageURLImpl;
import uk.ac.nesc.rapid.data.job.impl.JobImpl;
import uk.ac.nesc.rapid.element.impl.CreationFlagElement;
import uk.ac.nesc.rapid.element.impl.DeleteOnTerminationElement;
import uk.ac.nesc.rapid.element.impl.EnvironmentNameElement;
import uk.ac.nesc.rapid.element.impl.EnvironmentValueElement;
import uk.ac.nesc.rapid.element.impl.ExecutableElement;
import uk.ac.nesc.rapid.element.impl.FileNameElement;
import uk.ac.nesc.rapid.element.impl.FileSystemElement;
import uk.ac.nesc.rapid.element.impl.ParameterElement;
import uk.ac.nesc.rapid.element.impl.PathElement;
import uk.ac.nesc.rapid.element.impl.StderrElement;
import uk.ac.nesc.rapid.element.impl.StdinElement;
import uk.ac.nesc.rapid.element.impl.StdoutElement;
import uk.ac.nesc.rapid.element.impl.SubmitToElement;
import uk.ac.nesc.rapid.element.impl.VariableElement;
import uk.ac.nesc.rapid.element.impl.WorkingDirElement;
import uk.ac.nesc.rapid.xml.StackToParamRule;

public class JobReader {
    public static Job read(URL xmlFile) throws IOException, SAXException {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setNamespaceAware(true);
        JobImpl job = new JobImpl();
        digester.push((Object)job);
        String initialise = "*/initialise/";
        digester.addFactoryCreate("*/initialise/" + PathElement.getPattern(), (ObjectCreationFactory)new DataStageURLFactory(job));
        digester.addCallMethod("*/initialise/" + PathElement.getPattern(), "setPath", 1, new String[]{"uk.ac.nesc.rapid.data.Value"});
        digester.addFactoryCreate("*/initialise/" + DeleteOnTerminationElement.getPattern(), (ObjectCreationFactory)new DataStageFactory(job));
        digester.addCallMethod("*/initialise/" + DeleteOnTerminationElement.getPattern(), "setDeleteOnTermination", 1, new String[]{"uk.ac.nesc.rapid.data.Value"});
        digester.addFactoryCreate("*/initialise/" + CreationFlagElement.getPattern(), (ObjectCreationFactory)new DataStageFactory(job));
        digester.addCallMethod("*/initialise/" + CreationFlagElement.getPattern(), "setCreationFlag", 1, new String[]{"uk.ac.nesc.rapid.data.Value"});
        digester.addCallMethod("*/initialise/" + SubmitToElement.getPattern(), "setSubmissionServer", 1, new String[]{"uk.ac.nesc.rapid.data.Value"});
        digester.addCallMethod("*/initialise/" + StdinElement.getPattern(), "setStdin", 1, new String[]{"uk.ac.nesc.rapid.data.Value"});
        digester.addCallMethod("*/initialise/" + StdoutElement.getPattern(), "setStdout", 1, new String[]{"uk.ac.nesc.rapid.data.Value"});
        digester.addCallMethod("*/initialise/" + StderrElement.getPattern(), "setStderr", 1, new String[]{"uk.ac.nesc.rapid.data.Value"});
        digester.addCallMethod("*/initialise/" + WorkingDirElement.getPattern(), "setWorkingDir", 1, new String[]{"uk.ac.nesc.rapid.data.Value"});
        digester.addCallMethod("*/initialise/" + ParameterElement.getPattern(), "addParameter", 2, new String[]{"java.lang.Integer", "uk.ac.nesc.rapid.data.Value"});
        digester.addCallParam("*/initialise/" + ParameterElement.getPattern(), 0, "index");
        digester.addFactoryCreate("*/initialise/" + FileSystemElement.getPattern(), (ObjectCreationFactory)new DataStageURLFactory(job));
        digester.addCallMethod("*/initialise/" + FileSystemElement.getPattern(), "setFileSystem", 1, new String[]{"uk.ac.nesc.rapid.data.Value"});
        digester.addFactoryCreate("*/initialise/" + FileNameElement.getPattern(), (ObjectCreationFactory)new DataStageFactory(job));
        digester.addCallMethod("*/initialise/" + FileNameElement.getPattern(), "setFileName", 1, new String[]{"uk.ac.nesc.rapid.data.Value"});
        digester.addCallMethod("*/initialise/" + ExecutableElement.getPattern(), "setExecutable", 1, new String[]{"uk.ac.nesc.rapid.data.Value"});
        digester.addCallMethod("*/initialise/" + EnvironmentValueElement.getPattern(), "addEnvironmentValue", 2, new String[]{"java.lang.Integer", "uk.ac.nesc.rapid.data.Value"});
        digester.addCallParam("*/initialise/" + EnvironmentValueElement.getPattern(), 0, "index");
        digester.addCallMethod("*/initialise/" + EnvironmentNameElement.getPattern(), "addEnvironmentName", 2, new String[]{"java.lang.Integer", "uk.ac.nesc.rapid.data.Value"});
        digester.addCallParam("*/initialise/" + EnvironmentNameElement.getPattern(), 0, "index");
        digester.addCallMethod("*/initialise/" + VariableElement.getPattern(), "setVariable", 2, new String[]{"java.lang.String", "uk.ac.nesc.rapid.data.Value"});
        digester.addCallParam("*/initialise/" + VariableElement.getPattern(), 0, "name");
        digester.addObjectCreate("*/array", "uk.ac.nesc.rapid.data.impl.ArrayValue");
        digester.addObjectCreate("*/single", "uk.ac.nesc.rapid.data.impl.SingleValue");
        digester.addObjectCreate("*/uuid", "uk.ac.nesc.rapid.data.impl.UUIDValue");
        digester.addRule("*/array", (Rule)new StackToParamRule());
        digester.addRule("*/single", (Rule)new StackToParamRule());
        digester.addRule("*/uuid", (Rule)new StackToParamRule());
        digester.addCallMethod("*/value", "put", 1);
        digester.addCallParam("*/value", 0);
        digester.addCallMethod("*/min", "setMin", 1, new String[]{"java.lang.Double"});
        digester.addCallParam("*/min", 0);
        digester.addCallMethod("*/max", "setMax", 1, new String[]{"java.lang.Double"});
        digester.addCallParam("*/max", 0);
        digester.addCallMethod("*/regexp", "setRegExp", 1);
        digester.addCallParam("*/regexp", 0);
        digester.addCallMethod("*/errormessage", "setErrorMessage", 1);
        digester.addCallParam("*/errormessage", 0);
        digester.parse(xmlFile);
        return job;
    }

    public static class DataStageURLFactory
    implements ObjectCreationFactory {
        Job job;

        public DataStageURLFactory(Job job) {
            this.job = job;
        }

        public Object createObject(Attributes attributes) {
            try {
                StageType stageType;
                DataStage dataStage;
                String dataStageName = attributes.getValue("datastage");
                String type = attributes.getValue("type");
                if (!this.job.existsDataStage(dataStageName)) {
                    this.job.addDataStage(dataStageName, new DataStageImpl());
                }
                if (!(dataStage = this.job.getDataStage(dataStageName)).existsURL(stageType = StageType.parseString(type))) {
                    dataStage.setURL(new DataStageURLImpl(), StageType.parseString(type));
                }
                return dataStage.getURL(StageType.parseString(type));
            }
            catch (RapidException ex) {
                return null;
            }
        }

        public Digester getDigester() {
            return null;
        }

        public void setDigester(Digester digester) {
        }
    }

    public static class DataStageFactory
    implements ObjectCreationFactory {
        Job job;

        public DataStageFactory(Job job) {
            this.job = job;
        }

        public Object createObject(Attributes attributes) {
            String dataStageName = attributes.getValue("datastage");
            if (!this.job.existsDataStage(dataStageName)) {
                this.job.addDataStage(dataStageName, new DataStageImpl());
            }
            DataStage dataStage = null;
            try {
                dataStage = this.job.getDataStage(dataStageName);
            }
            catch (RapidException ex) {
                // empty catch block
            }
            return dataStage;
        }

        public Digester getDigester() {
            return null;
        }

        public void setDigester(Digester digester) {
        }
    }
}

