/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.job.Job;

public class StringUtil {
    public static String removeCR(String in) {
        if (in != null) {
            return in.replaceAll("\\n", "\\\\n\"+\n\"");
        }
        return "";
    }

    public static String insertVariables(String input, int index, Job job) throws RapidException {
        Pattern varPattern = Pattern.compile("(\\$)+\\([^ \\)]*\\)");
        Matcher varMatch = varPattern.matcher(input);
        String result = "";
        int start = 0;
        while (varMatch.find()) {
            result = result + input.substring(start, varMatch.start());
            start = varMatch.end();
            String var = varMatch.group();
            while (var.startsWith("$$")) {
                result = result + "$";
                var = var.substring(2);
            }
            if (var.startsWith("$(")) {
                try {
                    Value variableValue = job.getVariable(var.substring(2, var.length() - 1));
                    result = result + variableValue.get(index);
                    continue;
                }
                catch (RapidException ex) {
                    throw new RapidException("Unknown variable named " + var.substring(2, var.length() - 1));
                }
            }
            result = result + var;
        }
        result = result + input.substring(start, input.length());
        return result;
    }
}

