/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.jobmanager.other;

import java.util.List;
import java.util.Vector;
import org.icenigrid.gridsam.client.common.ClientSideJobManager;
import org.icenigrid.gridsam.core.ConfigurationException;
import org.icenigrid.gridsam.core.JobInstance;
import org.icenigrid.gridsam.core.JobManagerException;
import org.icenigrid.gridsam.core.UnknownJobException;
import org.icenigrid.schema.jsdl.y2005.m11.JobDefinitionDocument;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.impl.ArrayValue;
import uk.ac.nesc.rapid.jobsubmission.impl.JSDLGenerator;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.JobManager;

public class GridSam
extends JobManager {
    private String url = null;
    private String[] jobIdArray;

    public GridSam(String url) {
        this.url = url;
    }

    public String toString() {
        return "GridSam Server";
    }

    public Value monitor() {
        Vector<String> resultList = new Vector<String>();
        for (String gridSamJobID : this.jobIdArray) {
            try {
                ClientSideJobManager jobmanager = new ClientSideJobManager(this.url);
                JobInstance jobinstance = jobmanager.findJobInstance(gridSamJobID);
                if (jobinstance == null) {
                    resultList.add("Error retrieving job");
                    continue;
                }
                List stages = jobinstance.getJobStages();
                if (stages.isEmpty()) {
                    resultList.add("No Stages for job.");
                    continue;
                }
                resultList.add(jobinstance.getLastKnownStage().getDescription());
            }
            catch (ConfigurationException ex) {
                resultList.add("Configuration Error: " + ex.getMessage());
            }
            catch (UnknownJobException ex) {
                resultList.add("Unknown Job: " + ex.getMessage());
            }
            catch (JobManagerException ex) {
                resultList.add("Error in Job Manager: " + ex.getMessage());
            }
        }
        return new ArrayValue(resultList);
    }

    public void run() {
        int numberOfSubJobs = this.getJob().getNumberOfSubJobs();
        this.jobIdArray = new String[numberOfSubJobs];
        for (int subJob = 0; subJob < numberOfSubJobs; ++subJob) {
            try {
                ClientSideJobManager jobManager = new ClientSideJobManager(this.url);
                JobDefinitionDocument jsdlDocument = JSDLGenerator.getJSDL(this.getJob(), this.getFileSystemTable(), subJob);
                JobInstance jobInstance = jobManager.submitJob(jsdlDocument);
                this.jobIdArray[subJob] = jobInstance.getID();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

