/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.state;

public class BESPluginState {
    private final State state;
    private final String message;

    public BESPluginState() {
        this(State.INITIALISING);
    }

    public BESPluginState(State state, String message) {
        this.state = state;
        this.message = message;
    }

    public BESPluginState(State state) {
        this.state = state;
        switch (state) {
            case INITIALISING: {
                this.message = "The job is initialising";
                break;
            }
            case SUBMITTED: {
                this.message = "The job has been submitted";
                break;
            }
            case SUSPENDED: {
                this.message = "The job has been suspended";
                break;
            }
            case RUNNING: {
                this.message = "The job is running";
                break;
            }
            case FINISHED: {
                this.message = "The job has completed successfully";
                break;
            }
            default: {
                this.message = "An error has occurred!";
            }
        }
    }

    public State getState() {
        return this.state;
    }

    public String getMessage() {
        return this.message;
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    public boolean equals(Object state) {
        if (state.getClass() != BESPluginState.class) {
            return false;
        }
        return this.state == ((BESPluginState)state).getState();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        INITIALISING,
        SUBMITTED,
        SUSPENDED,
        RUNNING,
        FINISHED,
        ERROR;

    }
}

