/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.jobmanager.bes;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.globus.myproxy.MyProxyException;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.data.filesystem.FileSystemConnector;
import uk.ac.nesc.rapid.data.filesystem.security.Authentication;
import uk.ac.nesc.rapid.data.job.EnvironmentVariable;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.ForkProperties;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.state.BESPluginState;

public class ForkThread
implements Runnable {
    private org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(ForkThread.class);
    private BESPluginState state = new BESPluginState(BESPluginState.State.INITIALISING);
    private Job job;
    private int subJob;
    private ForkProperties properties;
    private AbstractFileSystem fileSystem = null;
    private FileObject submitFileObject = null;

    public ForkThread(Job job, int subJob, AbstractFileSystem fileSystem, ForkProperties properties) {
        this.job = job;
        this.subJob = subJob;
        this.fileSystem = fileSystem;
        this.properties = properties;
    }

    public BESPluginState getState() {
        return this.state;
    }

    public void run() {
        try {
            this.state = new BESPluginState(BESPluginState.State.SUBMITTED);
            Authentication auth = this.job.getAuthentication(this.fileSystem.getName(), null, null);
            this.submitFileObject = FileSystemConnector.getInstance().connect(this.fileSystem, auth);
            Value workingDirValue = this.job.getWorkingDir();
            if (workingDirValue != null) {
                this.submitFileObject = this.submitFileObject.resolveFile(this.job.getWorkingDir().get(this.subJob));
            }
            this.submitFileObject = this.submitFileObject.resolveFile(this.properties.getSubmitFileName() + this.job.getJobID().get(this.subJob) + ".sh");
            this.submitFileObject.createFile();
            FileContent submitFileContent = this.submitFileObject.getContent();
            OutputStream is = submitFileContent.getOutputStream();
            is.write(this.generateSubmitFile(this.job, this.subJob).getBytes());
            is.close();
            this.state = new BESPluginState(BESPluginState.State.RUNNING);
            String result = this.fileSystem.execute("source " + this.submitFileObject.getName().getPath());
            this.state = new BESPluginState(BESPluginState.State.FINISHED, result);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ForkThread.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (IOException ex) {
            this.state = new BESPluginState(BESPluginState.State.ERROR, "Error connecting to filesystem " + this.fileSystem.getName() + " : cause " + ex.getMessage());
        }
        catch (MyProxyException ex) {
            this.state = new BESPluginState(BESPluginState.State.ERROR, "MYPROXY LOOKUPS IN FORK SHOULD NOT HAPPEN");
        }
        catch (RapidException ex) {
            this.state = new BESPluginState(BESPluginState.State.ERROR, "Error! cause: " + ex.getMessage());
        }
    }

    private String generateSubmitFile(Job job, int subJob) {
        String result = "";
        result = result + "#!bin/sh\n";
        if (job.getWorkingDir().get(subJob) != null) {
            result = result + "cd " + job.getWorkingDir().get(subJob) + "\n";
        }
        result = result + "export PATH=$PATH:.\n";
        Collection<EnvironmentVariable> envCollection = job.getEnvironmentVariableCollection();
        for (EnvironmentVariable env : envCollection) {
            result = result + "export " + env.getName().get(subJob) + "=" + env.getValue().get(subJob) + "\n";
        }
        result = result + job.getExecutable().get(subJob);
        if (job.getParameterList().size() > 0) {
            result = result + " ";
            for (Value arg : job.getParameterList()) {
                result = result + arg.get(subJob) + " ";
            }
        }
        if (job.getStderr().size() > 0) {
            result = result + " 2> " + job.getStderr().get(subJob) + " ";
        }
        if (job.getStdin().size() > 0) {
            result = result + "< " + job.getStdin().get(subJob) + " ";
        }
        if (job.getStdout().size() > 0) {
            result = result + " 1> " + job.getStdout().get(subJob);
        }
        result = result + "\n";
        return result;
    }

    public void doCleanUp() throws RapidException {
        if (this.submitFileObject != null) {
            try {
                this.submitFileObject.delete();
            }
            catch (FileSystemException ex) {
                throw new RapidException("Error deleting submission file in Fork Plugin : " + ex.getMessage());
            }
        }
    }
}

