/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.jobmanager.bes;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.globus.myproxy.MyProxyException;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.filesystem.FileSystemConnector;
import uk.ac.nesc.rapid.data.filesystem.security.Authentication;
import uk.ac.nesc.rapid.data.job.EnvironmentVariable;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.BESPlugin;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.CondorProperties;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.state.BESPluginState;

public class CondorPlugin
extends BESPlugin {
    private CondorProperties properties;
    private FileObject submissionFile = null;

    public CondorPlugin(CondorProperties properties) {
        this.properties = properties;
    }

    public String doSubmit(int subJob) throws RapidException {
        try {
            Authentication auth = this.getJob().getAuthentication(this.fileSystem.getName());
            FileObject submitFileObject = FileSystemConnector.getInstance().connect(this.fileSystem, auth);
            Value workingDirValue = this.getJob().getWorkingDir();
            if (workingDirValue != null) {
                submitFileObject = submitFileObject.resolveFile(this.getJob().getWorkingDir().get(subJob));
            }
            submitFileObject = submitFileObject.resolveFile(this.properties.getSubmitFileName() + this.getJob().getJobID().get(subJob));
            submitFileObject.createFile();
            FileContent submitFileContent = submitFileObject.getContent();
            OutputStream is = submitFileContent.getOutputStream();
            is.write(this.generateSubmitFile(this.getJob(), subJob).getBytes());
            is.close();
            String command = "";
            if (this.properties.getCondorConfig() != null) {
                command = command + "export CONDOR_CONFIG=" + this.properties.getCondorConfig() + "; ";
            }
            command = command + "export PATH=$PATH:" + this.properties.getBinDirectory() + "; ";
            command = command + this.properties.getBinDirectory() + "/" + "condor_submit" + " " + submitFileObject.getName().getPath();
            this.submissionFile = submitFileObject;
            String result = this.fileSystem.execute(command);
            return this.getJobID(result);
        }
        catch (IOException ex) {
            throw new RapidException("Error connecting to filesystem " + this.fileSystem.getName() + " : cause " + ex.getMessage());
        }
        catch (MyProxyException ex) {
            throw new RapidException("Unable to get MyProxy credential for filesystem " + this.fileSystem.getName() + " : cause " + ex.getMessage());
        }
    }

    public BESPluginState doMonitor(String jobID) throws RapidException {
        String command = "";
        if (this.properties.getCondorConfig() != null) {
            command = "export CONDOR_CONFIG=" + this.properties.getCondorConfig() + "; ";
        }
        command = command + "export PATH=$PATH:" + this.properties.getBinDirectory() + "; ";
        command = command + "condor_q " + jobID + " -xml";
        String classad = this.fileSystem.execute(command);
        Pattern varPattern = Pattern.compile("<a n=\"JobStatus\"><i>\\d</i></a>");
        Matcher varMatch = varPattern.matcher(classad);
        if (varMatch.find()) {
            String jobStatusLine = classad.substring(varMatch.start(), varMatch.end());
            if (jobStatusLine == null || jobStatusLine.length() != 29) {
                throw new RapidException("Condor returned a classadd without a job status field.");
            }
            char jobStatusID = jobStatusLine.charAt(20);
            switch (jobStatusID) {
                case '1': {
                    return new BESPluginState(BESPluginState.State.SUSPENDED);
                }
                case '2': {
                    return new BESPluginState(BESPluginState.State.RUNNING);
                }
            }
            throw new RapidException("Error in reading Job Status from JobID ");
        }
        return new BESPluginState(BESPluginState.State.FINISHED);
    }

    private String getJobID(String condorOutput) {
        int start = condorOutput.lastIndexOf(" ");
        if (start > 0) {
            return condorOutput.substring(start, condorOutput.length() - 1);
        }
        return "ERROR";
    }

    private String generateSubmitFile(Job job, int subJob) {
        Collection<EnvironmentVariable> envCollection;
        String result = "";
        if (this.properties.getUniverse() != null) {
            result = result + "Universe = " + this.properties.getUniverse() + "\n";
        }
        for (String line : this.properties.getSubmitFileLines()) {
            result = result + line + "\n";
        }
        if (job.getWorkingDir() != null) {
            result = result + "Initialdir = " + job.getWorkingDir().get(subJob) + "\n";
        }
        if ((envCollection = job.getEnvironmentVariableCollection()).size() > 0) {
            result = result + "Environment = \"";
            int index = 0;
            for (EnvironmentVariable env : envCollection) {
                result = result + env.getName().get(subJob) + "=" + env.getValue().get(subJob);
                if (++index == envCollection.size()) continue;
                result = result + ";";
            }
            result = result + "\"\n";
        }
        if (job.getParameterList().size() > 0) {
            result = result + "Arguments = ";
            for (Value arg : job.getParameterList()) {
                result = result + arg.get(subJob) + " ";
            }
            result = result + "\n";
        }
        if (job.getStderr() != null) {
            result = result + "Error = " + job.getStderr().get(subJob) + "\n";
        }
        if (job.getStdin() != null) {
            result = result + "Input = " + job.getStdin().get(subJob) + "\n";
        }
        if (job.getStdout() != null) {
            result = result + "Output = " + job.getStdout().get(subJob) + "\n";
        }
        result = result + "Executable = " + job.getExecutable().get(subJob) + "\n";
        result = result + "Queue\n";
        return result;
    }

    protected void doCleanUp() throws RapidException {
        try {
            if (this.submissionFile != null) {
                this.submissionFile.delete();
            }
        }
        catch (FileSystemException ex) {
            throw new RapidException("FileSystem Error when cleaning up Condor submit file: " + ex.getMessage());
        }
    }
}

