/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.jobmanager.bes;

import java.util.Vector;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.data.impl.ArrayValue;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.state.BESPluginState;

public abstract class BESPlugin {
    private BESPluginState[] stateArray = new BESPluginState[]{new BESPluginState(BESPluginState.State.INITIALISING)};
    private String[] subJobIDArray = null;
    private Job job = null;
    protected AbstractFileSystem fileSystem = null;
    boolean submitted = false;

    protected synchronized void putState(int subJob, BESPluginState state) {
        if (subJob < this.stateArray.length) {
            this.stateArray[subJob] = state;
        }
    }

    protected synchronized void putSubJobID(int subJob, String jobID) {
        if (this.subJobIDArray.length < subJob) {
            this.subJobIDArray[subJob] = jobID;
        }
    }

    protected synchronized String getSubJobID(int subJob) {
        if (this.subJobIDArray.length < subJob) {
            return this.subJobIDArray[subJob];
        }
        return null;
    }

    public synchronized Value getState() {
        Vector<String> resultList = new Vector<String>();
        for (BESPluginState state : this.stateArray) {
            resultList.add(state.getMessage());
        }
        return new ArrayValue(resultList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSubmit(AbstractFileSystem fileSystem) throws RapidException {
        this.fileSystem = fileSystem;
        int numberOfSubJobs = this.getJob().getNumberOfSubJobs();
        String[] newSubJobIDArray = new String[numberOfSubJobs];
        BESPluginState[] newStateArray = new BESPluginState[numberOfSubJobs];
        for (int subJob = 0; subJob < numberOfSubJobs; ++subJob) {
            newStateArray[subJob] = new BESPluginState(BESPluginState.State.SUBMITTED);
            newSubJobIDArray[subJob] = this.doSubmit(subJob);
        }
        BESPlugin bESPlugin = this;
        synchronized (bESPlugin) {
            this.stateArray = newStateArray;
            this.subJobIDArray = newSubJobIDArray;
        }
        this.submitted = true;
    }

    protected abstract String doSubmit(int var1) throws RapidException;

    protected abstract BESPluginState doMonitor(String var1) throws RapidException;

    protected abstract void doCleanUp() throws RapidException;

    public final boolean isCompleted() {
        if (!this.submitted) {
            return false;
        }
        if (this.stateArray == null) {
            return false;
        }
        boolean done = true;
        for (BESPluginState state : this.stateArray) {
            done = done && (state.getState() == BESPluginState.State.ERROR || state.getState() == BESPluginState.State.FINISHED);
        }
        return done;
    }

    public final boolean isError() {
        if (!this.submitted) {
            return false;
        }
        if (this.stateArray == null) {
            return false;
        }
        boolean done = false;
        for (BESPluginState state : this.stateArray) {
            done = done || state.getState() == BESPluginState.State.ERROR;
        }
        return done;
    }

    public final void doMonitor() throws RapidException {
        if (!this.submitted) {
            return;
        }
        for (int id = 0; id < this.subJobIDArray.length; ++id) {
            BESPluginState.State currentState = this.stateArray[id].getState();
            if (currentState == BESPluginState.State.ERROR || currentState == BESPluginState.State.FINISHED) continue;
            this.doMonitor(id);
        }
    }

    public final void doMonitor(int id) throws RapidException {
        if (!this.submitted) {
            return;
        }
        if (id >= this.subJobIDArray.length) {
            throw new RapidException("No such subjob: " + id + " current number of sub jobs : " + this.subJobIDArray.length);
        }
        String subJobID = this.subJobIDArray[id];
        this.putState(id, this.doMonitor(subJobID));
    }

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }
}

