/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.impl;

import java.util.HashMap;
import java.util.Map;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.filesystem.FileSystemTable;
import uk.ac.nesc.rapid.data.impl.JobIDValue;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.jobsubmission.JobQueue;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.JobManager;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.JobManagerFactory;

public class JobQueueImpl
implements JobQueue {
    private String name = null;
    private JobManagerFactory factory;
    private Map<String, JobManager> managerList = new HashMap<String, JobManager>();

    public void setFactory(JobManagerFactory factory) {
        this.factory = factory;
    }

    public JobManagerFactory getJobManagerFactory() {
        return this.factory;
    }

    public void submit(Job job, FileSystemTable fileSystemTable) throws RapidException {
        JobManager manager = this.factory.newInstance();
        manager.setJob(job);
        manager.setFileSystemTable(fileSystemTable);
        job.finalise();
        this.managerList.put(JobIDValue.getJobID(job.getJobID()), manager);
        Thread thread = new Thread(manager);
        thread.start();
    }

    public String monitor(String jobID) {
        try {
            String uuid = JobIDValue.getJobID(jobID);
            int subJob = JobIDValue.getSubJobID(jobID);
            JobManager manager = this.managerList.get(uuid);
            if (manager == null) {
                return "No Such Job Found! " + jobID;
            }
            Value result = manager.monitor();
            return result.get(subJob);
        }
        catch (RapidException ex) {
            return "ERROR! " + ex.getMessage();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

