/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.element.impl;

import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.element.Element;

public class ParameterElement
extends Element {
    private int index;

    public Value get(Job job) throws RapidException {
        return job.getParameter(this.getIndex());
    }

    public void put(Job job, Value value) {
        if (this.isReadOnly()) {
            return;
        }
        job.addParameter(this.getIndex(), value);
    }

    public static String getPattern() {
        return "posix/parameter";
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        try {
            this.index = Integer.parseInt(index);
        }
        catch (NumberFormatException ex) {
            this.index = 0;
        }
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String toString() {
        String result = "";
        result = result + "Parameter\n";
        result = result + super.toString();
        result = result + " index: " + this.getIndex() + "\n";
        return result;
    }
}

